/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoop;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.impl.VertxHttp2Stream;
import java.io.RandomAccessFile;
import java.net.SocketAddress;

class FileStreamChannel
extends AbstractChannel {
    private static final SocketAddress LOCAL_ADDRESS = new StreamSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new StreamSocketAddress();
    private static final ChannelMetadata METADATA = new ChannelMetadata(true);
    private final ChannelConfig config = new DefaultChannelConfig((Channel)this);
    private boolean active;
    private boolean closed;
    private long bytesWritten;
    private final VertxHttp2Stream stream;
    final Handler<Void> drainHandler = v -> this.flush();

    FileStreamChannel(final Handler<AsyncResult<Long>> resultHandler, VertxHttp2Stream stream, final long offset, final long length) {
        super(null, Id.INSTANCE);
        this.pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof RandomAccessFile) {
                            ChannelFuture fut = ctx.writeAndFlush((Object)new ChunkedFile((RandomAccessFile)evt, offset, length, 8192));
                            fut.addListener(f -> {
                                if (resultHandler != null) {
                                    if (f.isSuccess()) {
                                        resultHandler.handle(Future.succeededFuture(FileStreamChannel.this.bytesWritten));
                                    } else {
                                        resultHandler.handle(Future.failedFuture(f.cause()));
                                    }
                                }
                                fut.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            });
                        }
                    }
                }});
            }
        }});
        this.stream = stream;
    }

    protected void doRegister() throws Exception {
        this.active = true;
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultUnsafe();
    }

    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof NioEventLoop;
    }

    protected SocketAddress localAddress0() {
        return LOCAL_ADDRESS;
    }

    protected SocketAddress remoteAddress0() {
        return REMOTE_ADDRESS;
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    protected void doClose() throws Exception {
        this.active = false;
        this.closed = true;
    }

    protected void doBeginRead() throws Exception {
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        ByteBuf chunk;
        while (!this.stream.isNotWritable() && (chunk = (ByteBuf)in.current()) != null) {
            this.bytesWritten += (long)chunk.readableBytes();
            this.stream.writeData(chunk.retain(), false);
            this.stream.handlerContext.flush();
            in.remove();
        }
    }

    public ChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isActive() {
        return this.active;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    static class Id
    implements ChannelId {
        static final ChannelId INSTANCE = new Id();

        private Id() {
        }

        public String asShortText() {
            return this.toString();
        }

        public String asLongText() {
            return this.toString();
        }

        public int compareTo(ChannelId o) {
            if (o instanceof Id) {
                return 0;
            }
            return this.asLongText().compareTo(o.asLongText());
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof Id;
        }

        public String toString() {
            return "stream";
        }
    }

    private class DefaultUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultUnsafe() {
            super((AbstractChannel)FileStreamChannel.this);
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            this.safeSetSuccess(promise);
        }
    }

    private static class StreamSocketAddress
    extends SocketAddress {
        private StreamSocketAddress() {
        }

        public String toString() {
            return "stream";
        }
    }
}

