/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import 'package:flutter/widgets.dart';
import 'package:playground_components/playground_components.dart';

import '../constants/global_shortcuts.dart';

class PlaygroundShortcutsManager extends StatelessWidget {
  const PlaygroundShortcutsManager({
    required this.child,
    required this.playgroundController,
  });

  final Widget child;
  final PlaygroundController playgroundController;

  @override
  Widget build(BuildContext context) {
    return ShortcutsManager(
      shortcuts: [
        ...playgroundController.shortcuts,
        BeamRunShortcut(
          onInvoke: () {
            final codeRunner = playgroundController.codeRunner;

            if (codeRunner.canRun) {
              codeRunner.runCode();

              PlaygroundComponents.analyticsService.sendUnawaited(
                RunStartedAnalyticsEvent(
                  snippetContext: codeRunner.eventSnippetContext!,
                  trigger: EventTrigger.shortcut,
                ),
              );
            }
          },
        ),
        ...globalShortcuts,
      ],
      child: child,
    );
  }
}
