<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->
# Welcome to a Tour of Beam

The Tour of Beam is a learning guide you can use to familiarize yourself with **Apache Beam**.

The tour is divided into a list of modules that contain learning units covering various Apache Beam features and principles. You can access the full list of modules by clicking the ‘<<’ button on the left. For each module, learning progress is displayed next to it.

Throughout the tour, you will find:

- **Learning materials**
- **Examples**
- **Exercises**
- **Challenges** for you to complete

Learning units are accompanied by code examples that you can review in the upper right pane. You can:

- **Edit the code**
- **Run the example**

After running the example, the output will be displayed in the lower right pane.

Each module also contains a challenge based on the material learned. Try to solve as many as you can, and if you need help, just click on the:

- **Hint** button
- **Solution** button to examine the correct solution

Now, let’s start the tour by learning some core Beam principles!