/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.emitter.jaxws;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.AxisServiceBasedMultiLanguageEmitter;
import org.apache.axis2.wsdl.codegen.writer.ExceptionWriter;
import org.apache.axis2.wsdl.codegen.writer.InterfaceImplementationWriter;
import org.apache.axis2.wsdl.codegen.writer.SkeletonInterfaceWriter;
import org.apache.axis2.wsdl.codegen.writer.SkeletonWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class JAXWSEmitter
extends AxisServiceBasedMultiLanguageEmitter {
    protected static final String TYPE_SUFFIX = "Type";
    protected static final String SERVICE_SUFFIX = "Service";
    protected static final String EXCEPTION_SUFFIX = "Exception";
    protected static final String JAXWS_PORT_TYPE_NAME = "JaxwsPortTypeName";
    protected static final String JAXWS_IMPL_SUFFIX = "Impl";

    @Override
    public void setCodeGenConfiguration(CodeGenConfiguration configuration) {
        super.setCodeGenConfiguration(configuration);
    }

    @Override
    public void emitSkeleton() throws CodeGenerationException {
        try {
            Map originalMap = this.getNewCopy(this.mapper.getAllMappedNames());
            for (AxisService this.axisService : this.axisServices) {
                this.axisBinding = this.axisService.getEndpoint(this.axisService.getEndpointName()).getBinding();
                if (this.mapper.isObjectMappingPresent()) {
                    this.copyMap(originalMap, this.mapper.getAllMappedNames());
                    this.updateMapperForMessageReceiver();
                } else {
                    this.copyToFaultMap();
                }
                this.generateAndPopulateFaultNames();
                this.writeExceptions();
                this.writeServiceEndpointInterface();
                this.writeServiceEndpointInterfaceImpl();
                this.writeServiceClass();
            }
            if (this.mapper.isObjectMappingPresent()) {
                this.copyMap(originalMap, this.mapper.getAllMappedNames());
            }
            if (this.codeGenConfiguration.isGenerateDeployementDescriptor()) {
                this.writeServiceXml();
            }
            if (!this.codeGenConfiguration.isFlattenFiles()) {
                this.writeAntBuild();
            }
        }
        catch (CodeGenerationException cgExp) {
            throw cgExp;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    protected void writeServiceEndpointInterface() throws Exception {
        Document skeletonModel = this.createDOMDocumentForSEI();
        this.debugLogDocument("Document for Service Endpoint Interface:", skeletonModel);
        SkeletonInterfaceWriter skeletonInterfaceWriter = new SkeletonInterfaceWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeFile(skeletonModel, skeletonInterfaceWriter);
    }

    protected void writeServiceEndpointInterfaceImpl() throws Exception {
        Document skeletonModel = this.createDOMDocumentForSEIImpl();
        this.debugLogDocument("Document for Service Endpoint Interface:", skeletonModel);
        InterfaceImplementationWriter interfaceImplementationWriter = new InterfaceImplementationWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeFile(skeletonModel, interfaceImplementationWriter);
    }

    @Override
    protected void writeExceptions() throws Exception {
        for (String key : this.fullyQualifiedFaultClassNameMap.keySet()) {
            Document skeletonModel = this.createDOMDocumentForException(key);
            this.debugLogDocument("Document for Exception Class:", skeletonModel);
            ExceptionWriter exceptionWriter = new ExceptionWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
            this.writeFile(skeletonModel, exceptionWriter);
        }
    }

    protected void writeServiceClass() throws Exception {
        Document skeletonModel = this.createDOMDocumentForServiceClass();
        this.debugLogDocument("Document for Service Endpoint Interface:", skeletonModel);
        SkeletonWriter skeletonInterfaceWriter = new SkeletonWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        this.writeFile(skeletonModel, skeletonInterfaceWriter);
    }

    @Override
    protected Document createDOMDocumentForServiceXML() {
        Document doc = this.getEmptyDocument();
        String className = null;
        String serviceName = null;
        Element rootElement = doc.createElement("interfaces");
        doc.appendChild(rootElement);
        for (AxisService this.axisService : this.axisServices) {
            this.axisBinding = this.axisService.getEndpoint(this.axisService.getEndpointName()).getBinding();
            serviceName = this.axisService.getName();
            className = (String)this.axisService.getParameter(JAXWS_PORT_TYPE_NAME).getValue() + JAXWS_IMPL_SUFFIX;
            rootElement.appendChild(this.getServiceElement(serviceName, className, doc));
        }
        return doc;
    }

    protected abstract Document createDOMDocumentForSEI() throws AxisFault;

    protected abstract Document createDOMDocumentForSEIImpl() throws AxisFault;

    protected abstract Document createDOMDocumentForServiceClass();

    protected abstract Document createDOMDocumentForException(String var1);

    @Override
    protected Element getServiceElement(String serviceName, String className, Document doc) {
        if (this.allServiceInfoHolder.get(serviceName) != null) {
            this.infoHolder = (Map)this.allServiceInfoHolder.get(serviceName);
        }
        Element rootElement = doc.createElement("interface");
        this.addAttribute(doc, "package", "", rootElement);
        this.addAttribute(doc, "classpackage", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", className, rootElement);
        if (!this.codeGenConfiguration.isWriteTestCase()) {
            this.addAttribute(doc, "testOmit", "true", rootElement);
        }
        this.addAttribute(doc, "servicename", serviceName, rootElement);
        for (Object key : mepToClassMap.keySet()) {
            if (!Boolean.TRUE.equals(this.infoHolder.get(key))) continue;
            Element elt = this.addElement(doc, "messagereceiver", this.makeJavaClassName(serviceName) + String.valueOf(mepToSuffixMap.get(key)), rootElement);
            this.addAttribute(doc, "mepURI", key.toString(), elt);
        }
        this.loadOperations(doc, rootElement, null);
        return rootElement;
    }

    public String extratClassName(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return "";
        }
        String className = fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46), fullyQualifiedName.length());
        if (className.charAt(0) == '.') {
            return className.substring(1);
        }
        return className;
    }

    protected String getFullyQualifiedName(String className, String packageName) {
        return packageName + "." + className;
    }

    protected String resolveNameCollision(String className, String packageName, String suffix) {
        className = this.makeJavaClassName(className);
        String fullQualifiedName = this.getFullyQualifiedName(className, packageName);
        Map map = this.mapper.getAllMappedNames();
        if (map.containsValue(fullQualifiedName)) {
            return className + suffix;
        }
        return className;
    }
}

