/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXConstrainedParseException;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.JiBXParseException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.BackFillHolder;
import org.jibx.runtime.impl.BackFillReference;
import org.jibx.runtime.impl.ITrackSourceImpl;
import org.jibx.runtime.impl.IXMLReaderFactory;
import org.jibx.runtime.impl.RuntimeSupport;
import org.jibx.runtime.impl.StringIntHashMap;

public class UnmarshallingContext
implements IUnmarshallingContext {
    private static final int INITIAL_STACK_SIZE = 20;
    private static final IXMLReaderFactory s_readerFactory = RuntimeSupport.loadFactory();
    private IBindingFactory m_factory;
    private StringIntHashMap m_classIndexMap;
    private IXMLReader m_reader;
    private int m_transientBase;
    private String[] m_transientUnmarshallerClasses;
    protected IUnmarshaller[] m_unmarshallers;
    protected String[] m_namespaces;
    protected String[] m_names;
    protected Map[] m_idMaps;
    protected String[] m_idClasses;
    protected int m_stackDepth;
    protected Object[] m_objectStack;
    protected Map m_unmarshalMap;
    protected Map m_transientUnmarshalMap;
    protected String m_idref;
    protected Object m_userContext;

    public UnmarshallingContext(int nmap, String[] umcs, String[] nss, String[] names, String[] idcs, IBindingFactory ifact) {
        this.m_transientBase = nmap - umcs.length;
        this.m_transientUnmarshallerClasses = new String[nmap - this.m_transientBase];
        this.m_unmarshallers = new IUnmarshaller[nmap];
        this.m_namespaces = new String[nmap];
        System.arraycopy(nss, 0, this.m_namespaces, 0, nss.length);
        this.m_names = new String[nmap];
        System.arraycopy(names, 0, this.m_names, 0, names.length);
        this.m_idClasses = idcs;
        int size = idcs == null ? 1 : idcs.length;
        this.m_idMaps = new HashMap[size];
        this.m_objectStack = new Object[20];
        this.m_factory = ifact;
        this.m_classIndexMap = ifact != null ? ifact.getClassIndexMap() : new StringIntHashMap();
    }

    public UnmarshallingContext() {
        this(0, Utility.EMPTY_STRING_ARRAY, Utility.EMPTY_STRING_ARRAY, Utility.EMPTY_STRING_ARRAY, Utility.EMPTY_STRING_ARRAY, null);
    }

    public static String buildNameString(String ns, String name) {
        if (ns == null || "".equals(ns)) {
            return "\"" + name + "\"";
        }
        return "\"{" + ns + "}" + name + "\"";
    }

    public String currentNameString() {
        return UnmarshallingContext.buildNameString(this.m_reader.getNamespace(), this.m_reader.getName());
    }

    public String buildPositionString() {
        return this.m_reader.buildPositionString();
    }

    public void throwStartTagNameError(String ns, String name) throws JiBXException {
        throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, name) + " start tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
    }

    public void throwEndTagNameError(String ns, String name) throws JiBXException {
        throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, name) + " end tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
    }

    public void throwNameException(String msg, String ns, String name) throws JiBXException {
        throw new JiBXException(msg + UnmarshallingContext.buildNameString(ns, name) + this.buildPositionString());
    }

    private void advance() throws JiBXException {
        this.m_reader.nextToken();
    }

    private boolean verifyNamespace(String ns) {
        if (ns == null || "".equals(ns)) {
            return this.m_reader.getNamespace().length() == 0;
        }
        return ns.equals(this.m_reader.getNamespace());
    }

    private String getAttributeValue(String ns, String name) {
        return this.m_reader.getAttributeValue(ns, name);
    }

    public void setDocument(InputStream ins, String name, String enc, boolean nsa) throws JiBXException {
        this.m_reader = this.m_reader == null ? s_readerFactory.createReader(ins, name, enc, nsa) : s_readerFactory.recycleReader(this.m_reader, ins, name, enc);
        this.reset();
    }

    @Override
    public void setDocument(InputStream ins, String enc) throws JiBXException {
        this.setDocument(ins, null, enc, true);
    }

    public void setDocument(Reader rdr, String name, boolean nsa) throws JiBXException {
        this.m_reader = this.m_reader == null ? s_readerFactory.createReader(rdr, name, nsa) : s_readerFactory.recycleReader(this.m_reader, rdr, name);
        this.reset();
    }

    @Override
    public void setDocument(Reader rdr) throws JiBXException {
        this.setDocument(rdr, null, true);
    }

    @Override
    public void setDocument(InputStream ins, String name, String enc) throws JiBXException {
        this.setDocument(ins, name, enc, true);
    }

    @Override
    public void setDocument(Reader rdr, String name) throws JiBXException {
        this.setDocument(rdr, name, true);
    }

    public void setDocument(IXMLReader rdr) {
        this.m_reader = rdr;
    }

    public void setFromContext(UnmarshallingContext parent) {
        this.m_reader = parent.m_reader;
    }

    @Override
    public void reset() {
        int i;
        for (i = 0; i < this.m_idMaps.length; ++i) {
            this.m_idMaps[i] = null;
        }
        for (i = 0; i < this.m_transientUnmarshallerClasses.length; ++i) {
            if (this.m_transientUnmarshallerClasses[i] != null) {
                this.m_transientUnmarshallerClasses[i] = null;
                this.m_namespaces[i + this.m_transientBase] = null;
                this.m_names[i + this.m_transientBase] = null;
            }
            this.m_unmarshallers[i] = null;
        }
        if (this.m_transientUnmarshalMap != null) {
            this.m_transientUnmarshalMap.clear();
        }
        this.m_idref = null;
        for (i = 0; i < this.m_objectStack.length; ++i) {
            this.m_objectStack[i] = null;
        }
        this.m_stackDepth = 0;
        this.m_userContext = null;
    }

    public String toStart() throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            return this.m_reader.getName();
        }
        while (true) {
            this.m_reader.next();
            switch (this.m_reader.getEventType()) {
                case 2: {
                    return this.m_reader.getName();
                }
                case 3: {
                    throw new JiBXException("Expected start tag, found end tag " + this.currentNameString() + " " + this.buildPositionString());
                }
                case 1: {
                    throw new JiBXException("Expected start tag, found end of document " + this.buildPositionString());
                }
            }
        }
    }

    public String toEnd() throws JiBXException {
        if (this.m_reader.getEventType() == 3) {
            return this.m_reader.getName();
        }
        while (true) {
            this.m_reader.next();
            switch (this.m_reader.getEventType()) {
                case 2: {
                    throw new JiBXException("Expected end tag, found start tag " + this.currentNameString() + " " + this.buildPositionString());
                }
                case 3: {
                    return this.m_reader.getName();
                }
                case 1: {
                    throw new JiBXException("Expected end tag, found end of document " + this.buildPositionString());
                }
            }
        }
    }

    public int toTag() throws JiBXException {
        int type = this.m_reader.getEventType();
        while (type != 2 && type != 3) {
            type = this.m_reader.next();
        }
        return this.m_reader.getEventType();
    }

    @Override
    public boolean isAt(String ns, String name) throws JiBXException {
        int type = this.m_reader.getEventType();
        while (type != 2 && type != 3) {
            type = this.m_reader.next();
        }
        return this.m_reader.getEventType() == 2 && this.m_reader.getName().equals(name) && this.verifyNamespace(ns);
    }

    public boolean hasAttribute(String ns, String name) throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            return this.getAttributeValue(ns, name) != null;
        }
        throw new JiBXException("Error parsing document " + this.buildPositionString());
    }

    public boolean hasAnyAttribute(String[] nss, String[] names) throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            for (int i = 0; i < names.length; ++i) {
                if (this.getAttributeValue(nss[i], names[i]) == null) continue;
                return true;
            }
            return false;
        }
        throw new JiBXException("Error parsing document " + this.buildPositionString());
    }

    public void checkAllowedAttributes(String[] nss, String[] names) throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            int count = this.m_reader.getAttributeCount();
            block0: for (int i = 0; i < count; ++i) {
                String name = this.m_reader.getAttributeName(i);
                String ns = this.m_reader.getAttributeNamespace(i);
                int base = 0;
                int limit = names.length - 1;
                while (base <= limit) {
                    String comp;
                    int cur = base + limit >> 1;
                    int diff = name.compareTo(names[cur]);
                    if (diff == 0 && (diff = (comp = nss[cur]) == null ? ns.compareTo("") : ns.compareTo(comp)) == 0) continue block0;
                    if (diff < 0) {
                        limit = cur - 1;
                        continue;
                    }
                    if (diff <= 0) continue;
                    base = cur + 1;
                }
                this.throwStartTagException("Illegal attribute " + UnmarshallingContext.buildNameString(ns, name));
            }
        } else {
            throw new JiBXException("Error parsing document " + this.buildPositionString());
        }
    }

    private void matchStart(String ns, String name) throws JiBXException {
        if (this.toTag() == 2) {
            if (!this.m_reader.getName().equals(name) || !this.verifyNamespace(ns)) {
                this.throwStartTagNameError(ns, name);
            }
        } else {
            throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, name) + " start tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
        }
    }

    public void parseToStartTag(String ns, String name) throws JiBXException {
        this.matchStart(ns, name);
    }

    public void parsePastStartTag(String ns, String name) throws JiBXException {
        this.matchStart(ns, name);
        this.advance();
    }

    public boolean parseIfStartTag(String ns, String name) throws JiBXException {
        if (this.isAt(ns, name)) {
            this.advance();
            return true;
        }
        return false;
    }

    public void parsePastCurrentEndTag(String ns, String name) throws JiBXException {
        int event = this.toTag();
        if (event == 3) {
            if (this.m_reader.getName().equals(name) && this.verifyNamespace(ns)) {
                this.advance();
            } else {
                this.throwEndTagNameError(ns, name);
            }
        } else {
            throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, name) + " end tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
        }
    }

    public void parsePastEndTag(String ns, String name) throws JiBXException {
        int event = this.m_reader.getEventType();
        if (event == 2) {
            this.advance();
        }
        this.parsePastCurrentEndTag(ns, name);
    }

    @Override
    public boolean isStart() throws JiBXException {
        int type = this.m_reader.getEventType();
        while (type != 2 && type != 3 && type != 1) {
            type = this.m_reader.next();
        }
        return this.m_reader.getEventType() == 2;
    }

    @Override
    public boolean isEnd() throws JiBXException {
        int type = this.m_reader.getEventType();
        while (type != 2 && type != 3) {
            type = this.m_reader.next();
        }
        return this.m_reader.getEventType() == 3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String accumulateText() throws JiBXException {
        String text = null;
        StringBuffer buff = null;
        block5: while (true) {
            switch (this.m_reader.getEventType()) {
                case 6: {
                    if (this.m_reader.getText() == null) {
                        throw new JiBXException("Unexpanded entity reference in text at " + this.buildPositionString());
                    }
                }
                case 4: 
                case 5: {
                    if (text == null) {
                        text = this.m_reader.getText();
                        break;
                    }
                    if (buff == null) {
                        buff = new StringBuffer(text);
                    }
                    buff.append(this.m_reader.getText());
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break block5;
                }
            }
            this.m_reader.nextToken();
        }
        if (buff != null) return buff.toString();
        if (text == null) {
            return "";
        }
        String string = text;
        return string;
    }

    public String parseContentText() throws JiBXException {
        return this.accumulateText();
    }

    public String parseContentText(String ns, String tag) throws JiBXException {
        String text = this.accumulateText();
        switch (this.m_reader.getEventType()) {
            case 3: {
                if (this.m_reader.getName().equals(tag) && this.verifyNamespace(ns)) {
                    this.m_reader.nextToken();
                    return text;
                }
                this.throwEndTagNameError(ns, tag);
            }
            case 2: {
                throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, tag) + " end tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
            }
            case 1: {
                throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, tag) + " end tag, found end of document " + this.buildPositionString());
            }
        }
        return null;
    }

    public int parseContentInt(String ns, String tag) throws JiBXException {
        String text = this.parseContentText(ns, tag);
        try {
            return Utility.parseInt(text);
        }
        catch (JiBXException ex) {
            throw new JiBXParseException(ex.getMessage() + ' ' + this.buildPositionString(), text, ns, tag, ex.getRootCause());
        }
    }

    public String parseElementText(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentText(ns, tag);
    }

    public String parseElementText(String ns, String tag, String dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.parseContentText(ns, tag);
        }
        return dflt;
    }

    public String attributeText(String ns, String name) throws JiBXException {
        String value = this.getAttributeValue(ns, name);
        if (value == null) {
            throw new JiBXException("Missing required attribute " + UnmarshallingContext.buildNameString(ns, name) + " " + this.buildPositionString());
        }
        return value;
    }

    public String attributeText(String ns, String name, String dflt) {
        String value = this.getAttributeValue(ns, name);
        if (value == null) {
            return dflt;
        }
        return value;
    }

    public Object findID(String id, int index) throws JiBXException {
        Map map = this.m_idMaps[index];
        if (map != null) {
            Object obj = map.get(id);
            if (obj == null || obj instanceof BackFillHolder) {
                return null;
            }
            if (this.m_idClasses == null || this.m_idClasses[index].equals(obj.getClass().getName())) {
                return obj;
            }
            this.throwStartTagException("IDREF element content mapped to wrong type");
        }
        return null;
    }

    public Object findDefinedID(String id, int index) throws JiBXException {
        Object obj = this.findID(id, index);
        if (obj == null) {
            this.throwStartTagException("ID " + id + " not defined");
        }
        return obj;
    }

    public Object parseElementForwardIDREF(String ns, String tag, int index) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        this.m_idref = this.parseContentText(ns, tag);
        return this.findID(this.m_idref, index);
    }

    public Object attributeForwardIDREF(String ns, String name, int index) throws JiBXException {
        this.m_idref = this.attributeText(ns, name);
        return this.findID(this.m_idref, index);
    }

    public Object parseElementExistingIDREF(String ns, String tag, int index) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        this.m_idref = this.parseContentText(ns, tag);
        return this.findDefinedID(this.m_idref, index);
    }

    public Object attributeExistingIDREF(String ns, String name, int index) throws JiBXException {
        this.m_idref = this.attributeText(ns, name);
        return this.findDefinedID(this.m_idref, index);
    }

    public int attributeInt(String ns, String name) throws JiBXException {
        String text = this.attributeText(ns, name);
        try {
            return Utility.parseInt(text);
        }
        catch (JiBXException ex) {
            throw new JiBXParseException(ex.getMessage() + ' ' + this.buildPositionString(), text, ns, name, ex.getRootCause());
        }
    }

    public int attributeInt(String ns, String name, int dflt) throws JiBXException {
        String value = this.getAttributeValue(ns, name);
        if (value == null) {
            return dflt;
        }
        try {
            return Utility.parseInt(value);
        }
        catch (JiBXException ex) {
            throw new JiBXParseException(ex.getMessage() + ' ' + this.buildPositionString(), value, ns, name, ex.getRootCause());
        }
    }

    public int parseElementInt(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentInt(ns, tag);
    }

    public int parseElementInt(String ns, String tag, int dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.parseContentInt(ns, tag);
        }
        return dflt;
    }

    public int convertEnum(String target, String[] enums, int[] vals) throws JiBXException {
        if (target == null) {
            this.throwStartTagException("Missing required enumeration value");
        }
        try {
            return Utility.enumValue(target, enums, vals);
        }
        catch (JiBXException ex) {
            throw new JiBXConstrainedParseException(ex.getMessage() + ' ' + this.buildPositionString(), target, enums);
        }
    }

    public int convertEnum(String target, String[] enums, int[] vals, int dflt) throws JiBXException {
        if (target == null) {
            return dflt;
        }
        try {
            return Utility.enumValue(target, enums, vals);
        }
        catch (JiBXException ex) {
            throw new JiBXConstrainedParseException(ex.getMessage() + ' ' + this.buildPositionString(), target, enums);
        }
    }

    public int attributeEnumeration(String ns, String name, String[] enums, int[] vals) throws JiBXException {
        try {
            return this.convertEnum(this.getAttributeValue(ns, name), enums, vals);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public int attributeEnumeration(String ns, String name, String[] enums, int[] vals, int dflt) throws JiBXException {
        try {
            return this.convertEnum(this.getAttributeValue(ns, name), enums, vals, dflt);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public int parseContentEnumeration(String ns, String tag, String[] enums, int[] vals) throws JiBXException {
        try {
            return this.convertEnum(this.parseContentText(ns, tag), enums, vals);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public int parseElementEnumeration(String ns, String tag, String[] enums, int[] vals, int dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            String text = this.parseContentText(ns, tag);
            try {
                return this.convertEnum(text, enums, vals, dflt);
            }
            catch (JiBXParseException e) {
                e.setNamespace(ns);
                e.setTagName(tag);
                throw e;
            }
        }
        return dflt;
    }

    public byte convertByte(String text) throws JiBXException {
        try {
            return Utility.parseByte(text);
        }
        catch (JiBXException ex) {
            throw new JiBXParseException(ex.getMessage() + ' ' + this.buildPositionString(), text, ex.getRootCause());
        }
    }

    public byte attributeByte(String ns, String name) throws JiBXException {
        try {
            return this.convertByte(this.attributeText(ns, name));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public byte attributeByte(String ns, String name, byte dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        try {
            return this.convertByte(text);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public byte parseContentByte(String ns, String tag) throws JiBXException {
        try {
            return this.convertByte(this.parseContentText(ns, tag));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public byte parseElementByte(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentByte(ns, tag);
    }

    public byte parseElementByte(String ns, String tag, byte dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            try {
                return this.convertByte(this.parseContentText(ns, tag));
            }
            catch (JiBXParseException e) {
                e.setNamespace(ns);
                e.setTagName(tag);
                throw e;
            }
        }
        return dflt;
    }

    public short convertShort(String text) throws JiBXException {
        try {
            return Utility.parseShort(text);
        }
        catch (JiBXException ex) {
            throw new JiBXParseException(ex.getMessage() + ' ' + this.buildPositionString(), text, ex.getRootCause());
        }
    }

    public short attributeShort(String ns, String name) throws JiBXException {
        try {
            return this.convertShort(this.attributeText(ns, name));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public short attributeShort(String ns, String name, short dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        try {
            return this.convertShort(text);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public short parseContentShort(String ns, String tag) throws JiBXException {
        try {
            return this.convertShort(this.parseContentText(ns, tag));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public short parseElementShort(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        try {
            return this.parseContentShort(ns, tag);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public short parseElementShort(String ns, String tag, short dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            try {
                return this.convertShort(this.parseContentText(ns, tag));
            }
            catch (JiBXParseException e) {
                e.setNamespace(ns);
                e.setTagName(tag);
                throw e;
            }
        }
        return dflt;
    }

    public char convertChar(String text) throws JiBXException {
        try {
            return Utility.parseChar(text);
        }
        catch (JiBXException ex) {
            throw new JiBXParseException(ex.getMessage() + ' ' + this.buildPositionString(), text, ex.getRootCause());
        }
    }

    public char attributeChar(String ns, String name) throws JiBXException {
        try {
            return this.convertChar(this.attributeText(ns, name));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public char attributeChar(String ns, String name, char dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        try {
            return this.convertChar(text);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public char parseContentChar(String ns, String tag) throws JiBXException {
        try {
            return this.convertChar(this.parseContentText(ns, tag));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public char parseElementChar(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        try {
            return this.parseContentChar(ns, tag);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public char parseElementChar(String ns, String tag, char dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            try {
                return this.convertChar(this.parseContentText(ns, tag));
            }
            catch (JiBXParseException e) {
                e.setNamespace(ns);
                e.setTagName(tag);
                throw e;
            }
        }
        return dflt;
    }

    public long convertLong(String text) throws JiBXException {
        try {
            return Utility.parseLong(text);
        }
        catch (JiBXException ex) {
            throw new JiBXParseException(ex.getMessage() + ' ' + this.buildPositionString(), text, ex.getRootCause());
        }
    }

    public long attributeLong(String ns, String name) throws JiBXException {
        try {
            return this.convertLong(this.attributeText(ns, name));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public long attributeLong(String ns, String name, long dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        try {
            return this.convertLong(text);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public long parseElementLong(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        try {
            return this.convertLong(this.parseContentText(ns, tag));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public long parseElementLong(String ns, String tag, long dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            try {
                return this.convertLong(this.parseContentText(ns, tag));
            }
            catch (JiBXParseException e) {
                e.setNamespace(ns);
                e.setTagName(tag);
                throw e;
            }
        }
        return dflt;
    }

    public boolean convertBoolean(String text) throws JiBXException {
        if ("true".equalsIgnoreCase(text) || "1".equals(text)) {
            return true;
        }
        if ("false".equalsIgnoreCase(text) || "0".equals(text)) {
            return false;
        }
        throw new JiBXParseException("Invalid boolean value " + this.buildPositionString(), text);
    }

    public boolean attributeBoolean(String ns, String name) throws JiBXException {
        try {
            return this.convertBoolean(this.attributeText(ns, name));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public boolean attributeBoolean(String ns, String name, boolean dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        try {
            return this.convertBoolean(text);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public boolean parseElementBoolean(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        try {
            return this.convertBoolean(this.parseContentText(ns, tag));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public boolean parseElementBoolean(String ns, String tag, boolean dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            try {
                return this.convertBoolean(this.parseContentText(ns, tag));
            }
            catch (JiBXParseException e) {
                e.setNamespace(ns);
                e.setTagName(tag);
                throw e;
            }
        }
        return dflt;
    }

    public float convertFloat(String text) throws JiBXException {
        try {
            return Utility.parseFloat(text);
        }
        catch (JiBXException ex) {
            throw new JiBXParseException(ex.getMessage() + ' ' + this.buildPositionString(), text, ex.getRootCause());
        }
    }

    public float attributeFloat(String ns, String name) throws JiBXException {
        try {
            return this.convertFloat(this.attributeText(ns, name));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public float attributeFloat(String ns, String name, float dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        try {
            return this.convertFloat(text);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public float parseElementFloat(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        try {
            return this.convertFloat(this.parseContentText(ns, tag));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public float parseElementFloat(String ns, String tag, float dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            try {
                return this.convertFloat(this.parseContentText(ns, tag));
            }
            catch (JiBXParseException e) {
                e.setNamespace(ns);
                e.setTagName(tag);
                throw e;
            }
        }
        return dflt;
    }

    public double convertDouble(String text) throws JiBXException {
        try {
            return Utility.parseDouble(text);
        }
        catch (JiBXException ex) {
            throw new JiBXParseException(ex.getMessage() + ' ' + this.buildPositionString(), text, ex.getRootCause());
        }
    }

    public double attributeDouble(String ns, String name) throws JiBXException {
        try {
            return this.convertDouble(this.attributeText(ns, name));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public double attributeDouble(String ns, String name, double dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        try {
            return this.convertDouble(text);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public double parseElementDouble(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        try {
            return this.convertDouble(this.parseContentText(ns, tag));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public double parseElementDouble(String ns, String tag, double dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            try {
                return this.convertDouble(this.parseContentText(ns, tag));
            }
            catch (JiBXParseException e) {
                e.setNamespace(ns);
                e.setTagName(tag);
                throw e;
            }
        }
        return dflt;
    }

    public Date convertDate(String text) throws JiBXException {
        try {
            return new Date(Utility.parseDateTime(text));
        }
        catch (JiBXException ex) {
            throw new JiBXParseException(ex.getMessage() + ' ' + this.buildPositionString(), text, ex.getRootCause());
        }
    }

    public Date attributeDate(String ns, String name) throws JiBXException {
        try {
            return this.convertDate(this.attributeText(ns, name));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public Date attributeDate(String ns, String name, Date dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        try {
            return this.convertDate(text);
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(name);
            throw e;
        }
    }

    public Date parseElementDate(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        try {
            return this.convertDate(this.parseContentText(ns, tag));
        }
        catch (JiBXParseException e) {
            e.setNamespace(ns);
            e.setTagName(tag);
            throw e;
        }
    }

    public Date parseElementDate(String ns, String tag, Date dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            try {
                return this.convertDate(this.parseContentText(ns, tag));
            }
            catch (JiBXParseException e) {
                e.setNamespace(ns);
                e.setTagName(tag);
                throw e;
            }
        }
        return dflt;
    }

    public void registerBackFill(String id, int index, BackFillReference fill) throws JiBXException {
        Object obj;
        HashMap<String, BackFillHolder> map = this.m_idMaps[index];
        if (map == null) {
            this.m_idMaps[index] = map = new HashMap<String, BackFillHolder>();
        }
        if ((obj = map.get(id)) == null) {
            String xclass = this.m_idClasses == null ? null : this.m_idClasses[index];
            BackFillHolder holder = new BackFillHolder(xclass);
            map.put(id, holder);
            holder.addBackFill(fill);
        } else if (obj instanceof BackFillHolder) {
            ((BackFillHolder)obj).addBackFill(fill);
        } else {
            throw new JiBXException("Internal operation error (back fill error) " + this.buildPositionString());
        }
    }

    public void registerBackFill(int index, BackFillReference fill) throws JiBXException {
        this.registerBackFill(this.m_idref, index, fill);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineID(String id, int index, Object obj) throws JiBXException {
        Object prior;
        HashMap<String, Object> map = this.m_idMaps[index];
        if (map == null) {
            this.m_idMaps[index] = map = new HashMap<String, Object>();
        }
        if ((prior = map.put(id, obj)) instanceof BackFillHolder) {
            BackFillHolder holder = (BackFillHolder)prior;
            String xclass = holder.getExpectedClass();
            if (xclass != null && !xclass.equals(obj.getClass().getName())) throw new JiBXException("ID object has wrong type " + this.buildPositionString());
            holder.defineValue(obj);
            return;
        } else {
            if (prior == null) return;
            throw new JiBXException("Duplicate ID definition " + this.buildPositionString());
        }
    }

    protected void mapUnmarshalling(int index) {
        Integer add = new Integer(index);
        Object value = this.m_transientUnmarshalMap.get(this.m_names[index]);
        if (value instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            list.add(add);
            this.m_transientUnmarshalMap.put(this.m_names[index], list);
        } else if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            list.add(add);
        } else {
            this.m_transientUnmarshalMap.put(this.m_names[index], add);
        }
    }

    public void addUnmarshalling(String mapname, String ns, String name, String cname) throws JiBXException {
        int index = this.m_classIndexMap.get(mapname);
        if (index < 0) {
            throw new JiBXException("No unmarshal mapping defined for class " + mapname);
        }
        this.m_namespaces[index] = ns;
        this.m_names[index] = name;
        this.m_transientUnmarshallerClasses[index - this.m_transientBase] = cname;
        if (this.m_transientUnmarshalMap != null && name != null) {
            this.mapUnmarshalling(index);
        }
    }

    public void removeUnmarshalling(String mapname) throws JiBXException {
        int index = this.m_classIndexMap.get(mapname);
        if (index < 0) {
            throw new JiBXException("No unmarshal mapping defined for class " + mapname);
        }
        if (this.m_transientUnmarshalMap != null && this.m_names[index] != null) {
            Object value = this.m_transientUnmarshalMap.get(this.m_names[index]);
            if (value instanceof Integer) {
                this.m_transientUnmarshalMap.remove(this.m_names[index]);
            } else if (value instanceof ArrayList) {
                ArrayList list = (ArrayList)value;
                for (int i = 0; i < list.size(); ++i) {
                    Integer item = (Integer)list.get(i);
                    if (item != index) continue;
                    list.remove(i);
                }
            }
        }
        this.m_namespaces[index] = null;
        this.m_names[index] = null;
        this.m_unmarshallers[index] = null;
        this.m_transientUnmarshallerClasses[index - this.m_transientBase] = null;
    }

    private IUnmarshaller getUnmarshaller(int index) throws JiBXException {
        if (this.m_unmarshallers[index] == null) {
            Class clas;
            String mname = this.m_factory.getUnmarshallerClasses()[index];
            if (mname != null) {
                clas = this.m_factory.getUnmarshallerClass(index);
            } else {
                mname = this.m_transientUnmarshallerClasses[index - this.m_transientBase];
                if (mname == null) {
                    throw new JiBXException("No unmarshaller defined for class " + this.m_factory.getMappedClasses()[index]);
                }
                clas = this.m_factory.loadClass(mname);
            }
            try {
                IUnmarshaller m;
                if (clas == null) {
                    throw new JiBXException("Unable to load unmarshaller class " + mname);
                }
                this.m_unmarshallers[index] = m = (IUnmarshaller)clas.newInstance();
            }
            catch (JiBXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JiBXException("Unable to create unmarshaller of class " + mname + ":", e);
            }
        }
        return this.m_unmarshallers[index];
    }

    @Override
    public IUnmarshaller getUnmarshaller(String mapname) throws JiBXException {
        int index = this.m_classIndexMap.get(mapname);
        if (index >= 0) {
            return this.getUnmarshaller(index);
        }
        throw new JiBXException("No unmarshal mapping defined for class " + mapname);
    }

    public IUnmarshaller getUnmarshaller(String ns, String name) throws JiBXException {
        block11: {
            int index;
            block13: {
                Object value;
                block12: {
                    String mns;
                    int i;
                    block8: {
                        block10: {
                            block9: {
                                if (this.m_unmarshalMap == null) {
                                    this.m_unmarshalMap = this.m_factory.getUnmarshalMap();
                                    this.m_transientUnmarshalMap = new HashMap();
                                    for (int i2 = 0; i2 < this.m_names.length; ++i2) {
                                        if (this.m_transientUnmarshallerClasses[i2 - this.m_transientBase] == null || this.m_names[i2] == null) continue;
                                        this.mapUnmarshalling(i2);
                                    }
                                }
                                if ((value = this.m_transientUnmarshalMap.get(name)) == null) break block8;
                                index = -1;
                                if (!(value instanceof Integer)) break block9;
                                i = (Integer)value;
                                mns = this.m_namespaces[i];
                                if (!(ns == mns || ns == null && mns.length() == 0 || mns == null && ns.length() == 0) && (ns == null || !ns.equals(mns))) break block10;
                                index = i;
                                break block10;
                            }
                            if (value instanceof List) {
                                List list = (List)value;
                                for (int i3 = 0; i3 < list.size(); ++i3) {
                                    int j = (Integer)list.get(i3);
                                    String mns2 = this.m_namespaces[j];
                                    if (!(ns == mns2 || ns == null && mns2.length() == 0 || mns2 == null && ns.length() == 0) && (ns == null || !ns.equals(mns2))) continue;
                                    index = j;
                                    break;
                                }
                            }
                        }
                        if (index >= 0) {
                            return this.getUnmarshaller(index);
                        }
                    }
                    if ((value = this.m_unmarshalMap.get(name)) == null) break block11;
                    index = -1;
                    if (!(value instanceof Integer)) break block12;
                    i = (Integer)value;
                    mns = this.m_namespaces[i];
                    if (!(ns == mns || ns == null && mns.length() == 0 || mns == null && ns.length() == 0) && (ns == null || !ns.equals(mns))) break block13;
                    index = i;
                    break block13;
                }
                if (value instanceof int[]) {
                    int[] ints = (int[])value;
                    for (int i = 0; i < ints.length; ++i) {
                        String mns = this.m_namespaces[ints[i]];
                        if (!(ns == mns || ns == null && mns.length() == 0 || mns == null && ns.length() == 0) && (ns == null || !ns.equals(mns))) continue;
                        index = ints[i];
                        break;
                    }
                }
            }
            if (index >= 0) {
                return this.getUnmarshaller(index);
            }
        }
        return null;
    }

    public Object unmarshalOptionalElement() throws JiBXException {
        IUnmarshaller unmarshal;
        int type = this.toTag();
        if (type == 2 && (unmarshal = this.getUnmarshaller(this.m_reader.getNamespace(), this.m_reader.getName())) != null) {
            return unmarshal.unmarshal(null, this);
        }
        return null;
    }

    public Object unmarshalElement(Class clas) throws JiBXException {
        String name = this.toStart();
        IUnmarshaller unmarshal = this.getUnmarshaller(this.m_reader.getNamespace(), name);
        if (unmarshal == null) {
            throw new JiBXException("No unmarshaller for element " + this.currentNameString() + " " + this.buildPositionString());
        }
        Object obj = unmarshal.unmarshal(null, this);
        if (!clas.isInstance(obj)) {
            throw new JiBXException("Element " + name + " not compatible with expected type " + clas.getName() + " " + this.buildPositionString());
        }
        return obj;
    }

    @Override
    public Object unmarshalElement() throws JiBXException {
        String name = this.toStart();
        IUnmarshaller unmarshal = this.getUnmarshaller(this.m_reader.getNamespace(), name);
        if (unmarshal == null) {
            throw new JiBXException("No unmarshaller for element " + this.currentNameString() + " " + this.buildPositionString());
        }
        return unmarshal.unmarshal(null, this);
    }

    public void parsePastElement(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        int depth = 0;
        while (true) {
            switch (this.m_reader.getEventType()) {
                case 3: {
                    if (depth == 0) {
                        if (this.m_reader.getName().equals(tag) && this.verifyNamespace(ns)) {
                            this.m_reader.nextToken();
                            return;
                        }
                        this.throwEndTagNameError(ns, tag);
                        break;
                    }
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                    break;
                }
            }
            this.m_reader.nextToken();
        }
    }

    public String getElementName() throws JiBXException {
        int type = this.m_reader.getEventType();
        if (type == 2 || type == 3) {
            return this.m_reader.getName();
        }
        return null;
    }

    public String getElementNamespace() throws JiBXException {
        int type = this.m_reader.getEventType();
        if (type == 2 || type == 3) {
            return this.m_reader.getNamespace();
        }
        return null;
    }

    public void throwStartTagException(String msg) throws JiBXException {
        throw new JiBXException(msg + " at tag " + this.currentNameString() + this.buildPositionString());
    }

    public void throwStartTagException(String msg, Exception ex) throws JiBXException {
        throw new JiBXException(msg + " at tag " + this.currentNameString() + this.buildPositionString(), ex);
    }

    public void throwException(String msg) throws JiBXException {
        throw new JiBXException(msg + " " + this.buildPositionString());
    }

    public void throwException(String msg, Exception ex) throws JiBXException {
        throw new JiBXException(msg + " " + this.buildPositionString(), ex);
    }

    @Override
    public Object unmarshalDocument(InputStream ins, String enc) throws JiBXException {
        this.setDocument(ins, enc);
        return this.unmarshalElement();
    }

    @Override
    public Object unmarshalDocument(Reader rdr) throws JiBXException {
        this.setDocument(rdr);
        return this.unmarshalElement();
    }

    @Override
    public Object unmarshalDocument(InputStream ins, String name, String enc) throws JiBXException {
        this.setDocument(ins, name, enc);
        return this.unmarshalElement();
    }

    @Override
    public Object unmarshalDocument(Reader rdr, String name) throws JiBXException {
        this.setDocument(rdr, name);
        return this.unmarshalElement();
    }

    public IBindingFactory getFactory() {
        return this.m_factory;
    }

    @Override
    public String getDocumentName() {
        return this.m_reader.getDocumentName();
    }

    public String getInputEncoding() {
        return this.m_reader.getInputEncoding();
    }

    @Override
    public void setUserContext(Object obj) {
        this.m_userContext = obj;
    }

    @Override
    public Object getUserContext() {
        return this.m_userContext;
    }

    @Override
    public void pushObject(Object obj) {
        int depth = this.m_stackDepth;
        if (depth >= this.m_objectStack.length) {
            Object[] stack = new Object[depth * 2];
            System.arraycopy(this.m_objectStack, 0, stack, 0, depth);
            this.m_objectStack = stack;
        }
        this.m_objectStack[depth] = obj;
        ++this.m_stackDepth;
    }

    public void trackObject(Object obj) {
        if (obj instanceof ITrackSourceImpl) {
            ((ITrackSourceImpl)obj).jibx_setSource(this.m_reader.getDocumentName(), this.m_reader.getLineNumber(), this.m_reader.getColumnNumber());
        }
    }

    public void pushTrackedObject(Object obj) {
        this.pushObject(obj);
        this.trackObject(obj);
    }

    @Override
    public void popObject() throws JiBXException {
        if (this.m_stackDepth > 0) {
            --this.m_stackDepth;
        } else {
            throw new JiBXException("No object on stack");
        }
    }

    @Override
    public int getStackDepth() {
        return this.m_stackDepth;
    }

    @Override
    public Object getStackObject(int depth) {
        if (depth >= 0 && depth < this.m_stackDepth) {
            return this.m_objectStack[this.m_stackDepth - depth - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Depth " + depth + " is out of range");
    }

    @Override
    public Object getStackTop() {
        if (this.m_stackDepth > 0) {
            return this.m_objectStack[this.m_stackDepth - 1];
        }
        return null;
    }

    public int getActiveNamespaceCount() {
        try {
            return this.m_reader.getNamespaceCount(this.m_reader.getNestingDepth());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Internal error: " + e.getMessage());
        }
    }

    public String getActiveNamespaceUri(int index) {
        return this.m_reader.getNamespaceUri(index);
    }

    public String getActiveNamespacePrefix(int index) {
        return this.m_reader.getNamespacePrefix(index);
    }

    public void skipElement() throws JiBXException {
        if (!this.isEnd()) {
            this.next();
            int depth = 1;
            while (depth > 0) {
                depth = this.isEnd() ? --depth : ++depth;
                this.next();
            }
        }
    }

    public int next() throws JiBXException {
        return this.m_reader.next();
    }

    public int nextToken() throws JiBXException {
        return this.m_reader.nextToken();
    }

    public int currentEvent() throws JiBXException {
        return this.m_reader.getEventType();
    }

    public String getName() {
        return this.m_reader.getName();
    }

    public String getNamespace() {
        return this.m_reader.getNamespace();
    }

    public String getPrefix() {
        return this.m_reader.getPrefix();
    }

    public int getAttributeCount() {
        return this.m_reader.getAttributeCount();
    }

    public String getAttributeName(int index) {
        return this.m_reader.getAttributeName(index);
    }

    public String getAttributeNamespace(int index) {
        return this.m_reader.getAttributeNamespace(index);
    }

    public String getAttributePrefix(int index) {
        return this.m_reader.getAttributePrefix(index);
    }

    public String getAttributeValue(int index) {
        return this.m_reader.getAttributeValue(index);
    }

    public int getNamespaceCount() {
        try {
            int level = this.m_reader.getNestingDepth();
            return this.m_reader.getNamespaceCount(level) - this.m_reader.getNamespaceCount(level - 1);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Internal error: " + e.getMessage());
        }
    }

    public String getNamespaceUri(int index) {
        int base = this.m_reader.getNamespaceCount(this.m_reader.getNestingDepth() - 1);
        return this.m_reader.getNamespaceUri(base + index);
    }

    public String getNamespacePrefix(int index) {
        int base = this.m_reader.getNamespaceCount(this.m_reader.getNestingDepth() - 1);
        return this.m_reader.getNamespacePrefix(base + index);
    }

    public String getNamespaceUri(String prefix) {
        return this.m_reader.getNamespace(prefix);
    }

    public String getText() {
        return this.m_reader.getText();
    }
}

