/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.receivers;

import java.security.PrivilegedAction;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.classloader.ThreadContextDescriptor;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.Replicator;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.Utils;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMessageReceiver
implements MessageReceiver {
    protected static final Log log = LogFactory.getLog(AbstractMessageReceiver.class);
    public static final String SCOPE = "scope";
    protected String serviceTCCL = null;
    public static final String SAVED_TCCL = "_SAVED_TCCL_";
    public static final String SAVED_MC = "_SAVED_MC_";
    public static final String DO_ASYNC = "messageReceiver.invokeOnSeparateThread";

    protected void replicateState(MessageContext messageContext) throws ClusteringFault {
        Replicator.replicate(messageContext);
    }

    protected abstract void invokeBusinessLogic(MessageContext var1) throws AxisFault;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(MessageContext messageCtx) throws AxisFault {
        block9: {
            String mep;
            EndpointReference replyTo = messageCtx.getReplyTo();
            if (replyTo != null && !replyTo.hasAnonymousAddress()) {
                this.processAsAsync(messageCtx);
                return;
            }
            if ((messageCtx.isPropertyTrue(DO_ASYNC) || messageCtx.getParameter(DO_ASYNC) != null && JavaUtils.isTrueExplicitly(messageCtx.getParameter(DO_ASYNC).getValue())) && (!WSDLUtil.isOutputPresentForMEP(mep = messageCtx.getAxisOperation().getMessageExchangePattern()) || replyTo != null && !replyTo.hasAnonymousAddress())) {
                this.processAsAsync(messageCtx);
                return;
            }
            ThreadContextDescriptor tc = ThreadContextDescriptor.setThreadContext(messageCtx);
            try {
                this.invokeBusinessLogic(messageCtx);
            }
            catch (AxisFault fault) {
                messageCtx.setProperty("SET_ROLLBACK_ONLY", true);
                if (messageCtx.getAxisOperation() instanceof InOnlyAxisOperation && !"http://www.w3.org/ns/wsdl/robust-in-only".equals(messageCtx.getAxisOperation().getMessageExchangePattern())) {
                    log.error((Object)fault);
                    break block9;
                }
                fault.setFaultType(1);
                throw fault;
            }
            finally {
                if ("request".equals(messageCtx.getAxisService().getScope())) {
                    DependencyManager.destroyServiceObject(messageCtx.getServiceContext());
                }
                this.restoreThreadContext(tc);
            }
        }
    }

    private void processAsAsync(MessageContext messageCtx) {
        AsyncMessageReceiverWorker worker = new AsyncMessageReceiverWorker(messageCtx);
        if (messageCtx.isDoingMTOM() || messageCtx.isDoingSwA()) {
            messageCtx.getEnvelope().buildWithAttachments();
        } else {
            messageCtx.getEnvelope().build();
        }
        messageCtx.getConfigurationContext().getThreadPool().execute(worker);
    }

    protected void restoreThreadContext(final ThreadContextDescriptor tc) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(tc.getOldClassLoader());
                return null;
            }
        });
        MessageContext.currentMessageContext.set(tc.getOldMessageContext());
    }

    protected Object makeNewServiceObject(MessageContext msgContext) throws AxisFault {
        Object serviceObject = Utils.createServiceObject(msgContext.getAxisService());
        if (serviceObject == null) {
            throw new AxisFault(Messages.getMessage("paramIsNotSpecified", "SERVICE_OBJECT_SUPPLIER"));
        }
        return serviceObject;
    }

    public SOAPFactory getSOAPFactory(MessageContext msgContext) throws AxisFault {
        String nsURI = msgContext.getEnvelope().getNamespace().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage("invalidSOAPversion"));
    }

    protected Object getTheImplementationObject(MessageContext msgContext) throws AxisFault {
        ServiceContext serviceContext = msgContext.getServiceContext();
        Object serviceimpl = serviceContext.getProperty("serviceObject");
        if (serviceimpl != null) {
            return serviceimpl;
        }
        serviceimpl = this.makeNewServiceObject(msgContext);
        DependencyManager.initServiceObject(serviceimpl, msgContext.getServiceContext());
        serviceContext.setProperty("serviceObject", serviceimpl);
        return serviceimpl;
    }

    public class AsyncMessageReceiverWorker
    implements Runnable {
        private MessageContext messageCtx;

        public AsyncMessageReceiverWorker(MessageContext messageCtx) {
            this.messageCtx = messageCtx;
        }

        @Override
        public void run() {
            try {
                ThreadContextDescriptor tc = ThreadContextDescriptor.setThreadContext(this.messageCtx);
                try {
                    AbstractMessageReceiver.this.invokeBusinessLogic(this.messageCtx);
                }
                finally {
                    AbstractMessageReceiver.this.restoreThreadContext(tc);
                }
            }
            catch (AxisFault e) {
                if (this.messageCtx.getAxisOperation() instanceof InOnlyAxisOperation) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(this.messageCtx, e);
                    AxisEngine.sendFault(faultContext);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

