/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import org.apache.trevni.ColumnFileWriter;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ColumnOutputBuffer;
import org.apache.trevni.ValueType;

class ArrayColumnOutputBuffer
extends ColumnOutputBuffer {
    private int length;
    private static final int NONE = -1;
    private int runLength;
    private int runValue = -1;

    public ArrayColumnOutputBuffer(ColumnFileWriter writer, ColumnMetaData meta) throws IOException {
        super(writer, meta);
        assert (this.getMeta().isArray() || this.getMeta().getParent() != null);
        assert (!this.getMeta().hasIndexValues());
    }

    @Override
    public void writeLength(int l) throws IOException {
        assert (this.length == 0);
        assert (l >= 0);
        this.length = l;
        if (l == this.runValue) {
            ++this.runLength;
            return;
        }
        this.flushRun();
        if (l == 1 || l == 0) {
            this.runLength = 1;
            this.runValue = l;
        } else {
            this.getBuffer().writeLength(l);
        }
    }

    @Override
    public void writeValue(Object value) throws IOException {
        assert (this.length > 0);
        if (this.getMeta().getType() != ValueType.NULL) {
            this.flushRun();
            this.getBuffer().writeValue(value, this.getMeta().getType());
        }
        --this.length;
    }

    @Override
    void flushBuffer() throws IOException {
        this.flushRun();
        super.flushBuffer();
    }

    private void flushRun() throws IOException {
        if (this.runLength == 0) {
            return;
        }
        if (this.runLength == 1) {
            this.getBuffer().writeLength(this.runValue);
        } else {
            this.getBuffer().writeLength(3 - this.runValue - (this.runLength << 1));
        }
        this.runLength = 0;
        this.runValue = -1;
    }
}

