/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@VisibleForTesting
public class BoundedAppender {
    @VisibleForTesting
    public static final String TRUNCATED_MESSAGES_TEMPLATE = "Diagnostic messages truncated, showing last %d chars out of %d:%n...%s";
    private final int limit;
    private final StringBuilder messages = new StringBuilder();
    private int totalCharacterCount = 0;

    public BoundedAppender(int limit) {
        Preconditions.checkArgument(limit > 0, "limit should be positive");
        this.limit = limit;
    }

    public BoundedAppender append(CharSequence csq) {
        this.appendAndCount(csq);
        this.checkAndCut();
        return this;
    }

    private void appendAndCount(CharSequence csq) {
        int before = this.messages.length();
        this.messages.append(csq);
        int after = this.messages.length();
        this.totalCharacterCount += after - before;
    }

    private void checkAndCut() {
        if (this.messages.length() > this.limit) {
            int newStart = this.messages.length() - this.limit;
            this.messages.delete(0, newStart);
        }
    }

    public int length() {
        return this.messages.length();
    }

    public int getLimit() {
        return this.limit;
    }

    public String toString() {
        if (this.messages.length() < this.totalCharacterCount) {
            return String.format(TRUNCATED_MESSAGES_TEMPLATE, this.messages.length(), this.totalCharacterCount, this.messages.toString());
        }
        return this.messages.toString();
    }
}

