/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.visitor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.asterix.om.typecomputer.impl.RecordMergeTypeComputer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class ArrayPathCheckerVisitor
implements IATypeVisitor<Boolean, AbstractCollectionType> {
    private final Set<AbstractCollectionType> seenCollections = new HashSet<AbstractCollectionType>();
    private boolean firstPath;

    public boolean containsMultipleArrayPaths(Collection<ARecordType> paths) throws AlgebricksException {
        ARecordType mergedPaths = ProjectionFiltrationTypeUtil.EMPTY_TYPE;
        for (ARecordType path : paths) {
            mergedPaths = (ARecordType)RecordMergeTypeComputer.merge((ARecordType)mergedPaths, (ARecordType)path);
        }
        this.firstPath = true;
        return (Boolean)mergedPaths.accept((IATypeVisitor)this, null) == false;
    }

    public Boolean visit(ARecordType recordType, AbstractCollectionType arg) {
        for (IAType child : recordType.getFieldTypes()) {
            if (((Boolean)child.accept((IATypeVisitor)this, null)).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(AbstractCollectionType collectionType, AbstractCollectionType arg) {
        if (this.firstPath) {
            this.seenCollections.add(collectionType);
        } else if (!this.seenCollections.contains(collectionType)) {
            return Boolean.FALSE;
        }
        return (Boolean)collectionType.getItemType().accept((IATypeVisitor)this, (Object)collectionType);
    }

    public Boolean visit(AUnionType unionType, AbstractCollectionType arg) {
        for (IAType child : unionType.getUnionList()) {
            if (((Boolean)child.accept((IATypeVisitor)this, (Object)arg)).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visitFlat(IAType flatType, AbstractCollectionType arg) {
        if (arg != null) {
            this.firstPath = false;
        }
        return Boolean.TRUE;
    }
}

