/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushSelectIntoJoinRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean planChanged;
        AbstractLogicalOperator son;
        HashSet joinLiveVarsLeft = new HashSet();
        HashSet joinLiveVarsRight = new HashSet();
        HashSet liveInOpsToPushLeft = new HashSet();
        HashSet liveInOpsToPushRight = new HashSet();
        ArrayList<ILogicalOperator> pushedOnLeft = new ArrayList<ILogicalOperator>();
        ArrayList<ILogicalOperator> pushedOnRight = new ArrayList<ILogicalOperator>();
        ArrayList<ILogicalOperator> pushedOnEither = new ArrayList<ILogicalOperator>();
        LinkedList<ILogicalOperator> notPushedStack = new LinkedList<ILogicalOperator>();
        HashSet usedVars = new HashSet();
        HashSet producedVars = new HashSet();
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        SelectOperator select = (SelectOperator)op;
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = son = (AbstractLogicalOperator)opRef2.getValue();
        boolean needToPushOps = false;
        while (son.isMap()) {
            needToPushOps = true;
            Mutable opRefLink = (Mutable)son.getInputs().get(0);
            son = (AbstractLogicalOperator)opRefLink.getValue();
        }
        if (son.getOperatorTag() != LogicalOperatorTag.INNERJOIN && son.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        boolean isLoj = son.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN;
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)son;
        Mutable joinBranchLeftRef = (Mutable)join.getInputs().get(0);
        Mutable joinBranchRightRef = (Mutable)join.getInputs().get(1);
        if (needToPushOps) {
            ILogicalOperator joinBranchLeft = (ILogicalOperator)joinBranchLeftRef.getValue();
            ILogicalOperator joinBranchRight = (ILogicalOperator)joinBranchRightRef.getValue();
            VariableUtilities.getLiveVariables((ILogicalOperator)joinBranchLeft, joinLiveVarsLeft);
            VariableUtilities.getLiveVariables((ILogicalOperator)joinBranchRight, joinLiveVarsRight);
            AbstractLogicalOperator opIter = op2;
            while (opIter != join) {
                LogicalOperatorTag tag = opIter.getOperatorTag();
                if (tag == LogicalOperatorTag.PROJECT) {
                    notPushedStack.addFirst((ILogicalOperator)opIter);
                } else {
                    VariableUtilities.getUsedVariables((ILogicalOperator)opIter, usedVars);
                    VariableUtilities.getProducedVariables((ILogicalOperator)opIter, producedVars);
                    if (usedVars.size() == 0) {
                        pushedOnEither.add((ILogicalOperator)opIter);
                    } else if (joinLiveVarsLeft.containsAll(usedVars)) {
                        pushedOnLeft.add((ILogicalOperator)opIter);
                        liveInOpsToPushLeft.addAll(producedVars);
                    } else if (joinLiveVarsRight.containsAll(usedVars)) {
                        pushedOnRight.add((ILogicalOperator)opIter);
                        liveInOpsToPushRight.addAll(producedVars);
                    } else {
                        return false;
                    }
                }
                Mutable opIterRef = (Mutable)opIter.getInputs().get(0);
                opIter = (ILogicalOperator)opIterRef.getValue();
            }
            if (isLoj && pushedOnLeft.isEmpty()) {
                return false;
            }
        }
        boolean intersectsAllBranches = true;
        boolean[] intersectsBranch = new boolean[join.getInputs().size()];
        LinkedList selectVars = new LinkedList();
        ((ILogicalExpression)select.getCondition().getValue()).getUsedVariables(selectVars);
        int i = 0;
        for (Mutable branch : join.getInputs()) {
            LinkedList branchVars = new LinkedList();
            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)branch.getValue()), branchVars);
            if (i == 0) {
                branchVars.addAll(liveInOpsToPushLeft);
            } else {
                branchVars.addAll(liveInOpsToPushRight);
            }
            if (OperatorPropertiesUtil.disjoint(selectVars, branchVars)) {
                intersectsAllBranches = false;
            } else {
                intersectsBranch[i] = true;
            }
            ++i;
        }
        if (!intersectsBranch[0] && !intersectsBranch[1]) {
            return false;
        }
        if (needToPushOps) {
            planChanged = this.pushOps(pushedOnEither, (Mutable<ILogicalOperator>)(intersectsBranch[0] ? joinBranchLeftRef : joinBranchRightRef), context);
            planChanged |= this.pushOps(pushedOnLeft, (Mutable<ILogicalOperator>)joinBranchLeftRef, context);
            planChanged |= this.pushOps(pushedOnRight, (Mutable<ILogicalOperator>)joinBranchRightRef, context);
        } else {
            planChanged = false;
        }
        if (intersectsAllBranches) {
            if (isLoj) {
                notPushedStack.addFirst((ILogicalOperator)select);
            } else {
                PushSelectIntoJoinRule.addCondToJoin(select, join, context);
                planChanged = true;
            }
        } else {
            Iterator branchIter = join.getInputs().iterator();
            ILogicalExpression selectCondition = (ILogicalExpression)select.getCondition().getValue();
            boolean lojToInner = false;
            for (int j = 0; j < intersectsBranch.length; ++j) {
                Mutable branch = (Mutable)branchIter.next();
                boolean inter = intersectsBranch[j];
                if (!inter) continue;
                if (j > 0 && isLoj) {
                    FunctionIdentifier isMissingNullFunction = OperatorPropertiesUtil.getIsMissingNullFunction((IAlgebricksConstantValue)((LeftOuterJoinOperator)join).getMissingValue());
                    if (this.containsNotMissingFiltering(selectCondition, isMissingNullFunction)) {
                        lojToInner = true;
                    }
                    notPushedStack.addFirst((ILogicalOperator)select);
                    continue;
                }
                PushSelectIntoJoinRule.copySelectToBranch(select, (Mutable<ILogicalOperator>)branch, context);
                planChanged = true;
            }
            if (lojToInner) {
                InnerJoinOperator innerJoin = new InnerJoinOperator(join.getCondition());
                innerJoin.getInputs().addAll(join.getInputs());
                join = innerJoin;
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)join);
                planChanged = true;
            }
        }
        return planChanged |= this.applyNonPushed(opRef, notPushedStack, (ILogicalOperator)join, context);
    }

    private boolean applyNonPushed(Mutable<ILogicalOperator> opRef, LinkedList<ILogicalOperator> notPushedStack, ILogicalOperator top, IOptimizationContext context) throws AlgebricksException {
        switch (notPushedStack.size()) {
            case 0: {
                if (opRef.getValue() == top) {
                    return false;
                }
                opRef.setValue((Object)top);
                return true;
            }
            case 1: {
                ILogicalOperator notPushedOp = notPushedStack.peek();
                if (opRef.getValue() != notPushedOp || ((Mutable)((ILogicalOperator)opRef.getValue()).getInputs().get(0)).getValue() != top) break;
                return false;
            }
        }
        for (ILogicalOperator npOp : notPushedStack) {
            List npInpList = npOp.getInputs();
            npInpList.clear();
            npInpList.add(new MutableObject((Object)top));
            context.computeAndSetTypeEnvironmentForOperator(npOp);
            top = npOp;
        }
        opRef.setValue((Object)top);
        return true;
    }

    private boolean pushOps(List<ILogicalOperator> opList, Mutable<ILogicalOperator> joinBranch, IOptimizationContext context) throws AlgebricksException {
        if (opList.isEmpty()) {
            return false;
        }
        ILogicalOperator topOp = (ILogicalOperator)joinBranch.getValue();
        ListIterator<ILogicalOperator> iter = opList.listIterator(opList.size());
        while (iter.hasPrevious()) {
            ILogicalOperator op = iter.previous();
            List opInpList = op.getInputs();
            opInpList.clear();
            opInpList.add(new MutableObject((Object)topOp));
            topOp = op;
            context.computeAndSetTypeEnvironmentForOperator(op);
        }
        joinBranch.setValue((Object)topOp);
        return true;
    }

    private static void addCondToJoin(SelectOperator select, AbstractBinaryJoinOperator join, IOptimizationContext context) {
        ILogicalExpression cond = (ILogicalExpression)join.getCondition().getValue();
        if (OperatorPropertiesUtil.isAlwaysTrueCond((ILogicalExpression)cond)) {
            join.getCondition().setValue((Object)((ILogicalExpression)select.getCondition().getValue()));
        } else {
            AbstractFunctionCallExpression fcond;
            boolean bAddedToConj = false;
            if (cond.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && (fcond = (AbstractFunctionCallExpression)cond).getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.AND)) {
                ScalarFunctionCallExpression newCond = new ScalarFunctionCallExpression(context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.AND));
                newCond.getArguments().add(select.getCondition());
                newCond.getArguments().addAll(fcond.getArguments());
                join.getCondition().setValue((Object)newCond);
                bAddedToConj = true;
            }
            if (!bAddedToConj) {
                ScalarFunctionCallExpression newCond = new ScalarFunctionCallExpression(context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.AND), new Mutable[]{select.getCondition(), new MutableObject((Object)((ILogicalExpression)join.getCondition().getValue()))});
                join.getCondition().setValue((Object)newCond);
            }
        }
    }

    private static void copySelectToBranch(SelectOperator select, Mutable<ILogicalOperator> branch, IOptimizationContext context) throws AlgebricksException {
        SelectOperator newSelect = new SelectOperator(select.getCondition(), select.getRetainMissingAsValue(), select.getMissingPlaceholderVariable());
        MutableObject newRef = new MutableObject((Object)((ILogicalOperator)branch.getValue()));
        newSelect.getInputs().add(newRef);
        branch.setValue((Object)newSelect);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newSelect);
    }

    private boolean containsNotMissingFiltering(ILogicalExpression expr, FunctionIdentifier isMissingNullFunId) {
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        ScalarFunctionCallExpression func = (ScalarFunctionCallExpression)expr;
        if (func.getFunctionIdentifier() == AlgebricksBuiltinFunctions.AND) {
            for (Mutable argumentRef : func.getArguments()) {
                if (!this.containsNotMissingFiltering((ILogicalExpression)argumentRef.getValue(), isMissingNullFunId)) continue;
                return true;
            }
            return false;
        }
        if (func.getFunctionIdentifier() != AlgebricksBuiltinFunctions.NOT) {
            return false;
        }
        ILogicalExpression arg = (ILogicalExpression)((Mutable)func.getArguments().get(0)).getValue();
        if (arg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        ScalarFunctionCallExpression func2 = (ScalarFunctionCallExpression)arg;
        return func2.getFunctionIdentifier().equals((Object)isMissingNullFunId);
    }
}

