/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.statement.CreateAdapterStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateLibraryStatement;
import org.apache.asterix.lang.common.statement.CreateSynonymStatement;
import org.apache.asterix.lang.common.statement.CreateViewStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.UpsertStatement;
import org.apache.asterix.metadata.dataset.hints.DatasetHints;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLangTranslator {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final String INVALID_OPERATION_MESSAGE = "Invalid operation - %s";
    protected static final String BAD_DATAVERSE_DML_MESSAGE = "%s operation is not permitted in " + IdentifierUtil.dataverse() + " %s";
    protected static final String BAD_DATAVERSE_DDL_MESSAGE = "Cannot %s " + IdentifierUtil.dataverse() + ": %s";
    protected static final String BAD_DATAVERSE_OBJECT_DDL_MESSAGE = "Cannot %s a %s belonging to the " + IdentifierUtil.dataverse() + ": %s";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateOperation(ICcApplicationContext appCtx, Dataverse defaultDataverse, Statement stmt) throws AlgebricksException {
        int maxWaitCycles;
        IClusterStateManager clusterStateManager = appCtx.getClusterStateManager();
        IGlobalRecoveryManager globalRecoveryManager = appCtx.getGlobalRecoveryManager();
        if (!clusterStateManager.getState().equals((Object)IClusterManagementWork.ClusterState.ACTIVE) || !globalRecoveryManager.isRecoveryCompleted()) {
            maxWaitCycles = appCtx.getExternalProperties().getMaxWaitClusterActive();
            try {
                clusterStateManager.waitForState(IClusterManagementWork.ClusterState.ACTIVE, (long)maxWaitCycles, TimeUnit.SECONDS);
            }
            catch (HyracksDataException e) {
                throw new AsterixException((Throwable)e);
            }
            catch (InterruptedException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Thread interrupted while waiting for cluster to be " + IClusterManagementWork.ClusterState.ACTIVE);
                }
                Thread.currentThread().interrupt();
            }
            IClusterStateManager e = clusterStateManager;
            synchronized (e) {
                if (!clusterStateManager.getState().equals((Object)IClusterManagementWork.ClusterState.ACTIVE)) {
                    ClusterPartition[] configuredPartitions = clusterStateManager.getClusterPartitons();
                    HashSet<String> inactiveNodes = new HashSet<String>();
                    for (ClusterPartition cp : configuredPartitions) {
                        if (cp.isActive()) continue;
                        inactiveNodes.add(cp.getNodeId());
                    }
                    throw AsterixException.create((ErrorCode)ErrorCode.CLUSTER_STATE_UNUSABLE, (Serializable[])new Serializable[]{Arrays.toString(inactiveNodes.toArray())});
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Cluster is now " + IClusterManagementWork.ClusterState.ACTIVE);
                }
            }
        }
        if (!globalRecoveryManager.isRecoveryCompleted()) {
            maxWaitCycles = appCtx.getExternalProperties().getMaxWaitClusterActive();
            try {
                for (int waitCycleCount = 0; !globalRecoveryManager.isRecoveryCompleted() && waitCycleCount < maxWaitCycles; ++waitCycleCount) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Thread interrupted while waiting for cluster to complete global recovery ");
                }
                Thread.currentThread().interrupt();
            }
            if (!globalRecoveryManager.isRecoveryCompleted()) {
                throw new AsterixException("Cluster Global recovery is not yet complete and the system is in " + IClusterManagementWork.ClusterState.ACTIVE + " state");
            }
        }
        boolean invalidOperation = false;
        String message = null;
        DataverseName dataverseName = defaultDataverse != null ? defaultDataverse.getDataverseName() : null;
        switch (stmt.getKind()) {
            case LOAD: {
                LoadStatement loadStmt = (LoadStatement)stmt;
                if (loadStmt.getDataverseName() != null) {
                    dataverseName = loadStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_DML_MESSAGE, "Load", dataverseName);
                break;
            }
            case INSERT: {
                InsertStatement insertStmt = (InsertStatement)stmt;
                if (insertStmt.getDataverseName() != null) {
                    dataverseName = insertStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_DML_MESSAGE, "Insert", dataverseName);
                break;
            }
            case UPSERT: {
                UpsertStatement upsertStmt = (UpsertStatement)stmt;
                if (upsertStmt.getDataverseName() != null) {
                    dataverseName = upsertStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_DML_MESSAGE, "Upsert", dataverseName);
                break;
            }
            case DELETE: {
                DeleteStatement deleteStmt = (DeleteStatement)stmt;
                if (deleteStmt.getDataverseName() != null) {
                    dataverseName = deleteStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_DML_MESSAGE, "Delete", dataverseName);
                break;
            }
            case CREATE_DATAVERSE: {
                CreateDataverseStatement dvCreateStmt = (CreateDataverseStatement)stmt;
                dataverseName = dvCreateStmt.getDataverseName();
                boolean bl = invalidOperation = FunctionConstants.ASTERIX_DV.equals((Object)dataverseName) || FunctionConstants.ALGEBRICKS_DV.equals((Object)dataverseName);
                if (!invalidOperation) break;
                message = String.format(BAD_DATAVERSE_DDL_MESSAGE, "create", dataverseName);
                break;
            }
            case DATAVERSE_DROP: {
                DataverseDropStatement dvDropStmt = (DataverseDropStatement)stmt;
                dataverseName = dvDropStmt.getDataverseName();
                invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName);
                if (!invalidOperation) break;
                message = String.format(BAD_DATAVERSE_DDL_MESSAGE, "drop", dataverseName);
                break;
            }
            case DATASET_DECL: {
                Map hints;
                DatasetDecl dsCreateStmt = (DatasetDecl)stmt;
                if (dsCreateStmt.getDataverse() != null) {
                    dataverseName = dsCreateStmt.getDataverse();
                }
                if (invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName)) {
                    message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "create", IdentifierUtil.dataset(), dataverseName);
                }
                if (invalidOperation || (hints = dsCreateStmt.getHints()) == null || hints.isEmpty()) break;
                StringBuilder errorMsgBuffer = new StringBuilder();
                for (Map.Entry hint : hints.entrySet()) {
                    Pair validationResult = DatasetHints.validate((ICcApplicationContext)appCtx, (String)((String)hint.getKey()), (String)((String)hint.getValue()));
                    if (((Boolean)validationResult.first).booleanValue()) continue;
                    errorMsgBuffer.append(StringUtils.capitalize((String)IdentifierUtil.dataset())).append(": ").append(dsCreateStmt.getName().getValue()).append(" error in processing hint: ").append((String)hint.getKey()).append(" ").append((String)validationResult.second);
                    errorMsgBuffer.append(" \n");
                }
                boolean bl = invalidOperation = errorMsgBuffer.length() > 0;
                if (!invalidOperation) break;
                message = errorMsgBuffer.toString();
                break;
            }
            case DATASET_DROP: {
                DropDatasetStatement dsDropStmt = (DropDatasetStatement)stmt;
                if (dsDropStmt.getDataverseName() != null) {
                    dataverseName = dsDropStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "drop", IdentifierUtil.dataset(), dataverseName);
                break;
            }
            case INDEX_DROP: {
                IndexDropStatement idxDropStmt = (IndexDropStatement)stmt;
                if (idxDropStmt.getDataverseName() != null) {
                    dataverseName = idxDropStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "drop", "index", dataverseName);
                break;
            }
            case TYPE_DECL: {
                TypeDecl typeCreateStmt = (TypeDecl)stmt;
                if (typeCreateStmt.getDataverseName() != null) {
                    dataverseName = typeCreateStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "create", "type", dataverseName);
                break;
            }
            case TYPE_DROP: {
                TypeDropStatement typeDropStmt = (TypeDropStatement)stmt;
                if (typeDropStmt.getDataverseName() != null) {
                    dataverseName = typeDropStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "drop", "type", dataverseName);
                break;
            }
            case CREATE_SYNONYM: {
                CreateSynonymStatement synCreateStmt = (CreateSynonymStatement)stmt;
                if (synCreateStmt.getDataverseName() != null) {
                    dataverseName = synCreateStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "create", "synonym", dataverseName);
                break;
            }
            case FUNCTION_DECL: {
                FunctionDecl fnDeclStmt = (FunctionDecl)stmt;
                FunctionSignature fnDeclSignature = fnDeclStmt.getSignature();
                if (fnDeclSignature.getDataverseName() != null) {
                    dataverseName = fnDeclSignature.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "declare", "function", dataverseName);
                break;
            }
            case CREATE_FUNCTION: {
                CreateFunctionStatement fnCreateStmt = (CreateFunctionStatement)stmt;
                FunctionSignature fnCreateSignature = fnCreateStmt.getFunctionSignature();
                if (fnCreateSignature.getDataverseName() != null) {
                    dataverseName = fnCreateSignature.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "create", "function", dataverseName);
                break;
            }
            case CREATE_LIBRARY: {
                CreateLibraryStatement libCreateStmt = (CreateLibraryStatement)stmt;
                if (libCreateStmt.getDataverseName() != null) {
                    dataverseName = libCreateStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "create", "library", dataverseName);
                break;
            }
            case CREATE_ADAPTER: {
                CreateAdapterStatement adCreateStmt = (CreateAdapterStatement)stmt;
                if (adCreateStmt.getDataverseName() != null) {
                    dataverseName = adCreateStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "create", "adapter", dataverseName);
                break;
            }
            case CREATE_VIEW: {
                CreateViewStatement viewCreateStmt = (CreateViewStatement)stmt;
                if (viewCreateStmt.getDataverseName() != null) {
                    dataverseName = viewCreateStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "create", "view", dataverseName);
                break;
            }
            case CREATE_FEED: {
                CreateFeedStatement feedCreateStmt = (CreateFeedStatement)stmt;
                if (feedCreateStmt.getDataverseName() != null) {
                    dataverseName = feedCreateStmt.getDataverseName();
                }
                if (!(invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName))) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "create", "feed", dataverseName);
                break;
            }
            case CREATE_FEED_POLICY: {
                invalidOperation = AbstractLangTranslator.isMetadataDataverse(dataverseName);
                if (!invalidOperation) break;
                message = String.format(BAD_DATAVERSE_OBJECT_DDL_MESSAGE, "create", "ingestion policy", dataverseName);
            }
        }
        if (invalidOperation) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, stmt.getSourceLocation(), new Serializable[]{String.format(INVALID_OPERATION_MESSAGE, message)});
        }
    }

    protected static boolean isMetadataDataverse(DataverseName dataverseName) {
        return MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)dataverseName);
    }
}

