/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.spatial.utils;

import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.runtime.evaluators.common.SpatialUtils;
import org.apache.asterix.runtime.operators.joins.spatial.utils.ISpatialJoinUtil;
import org.apache.asterix.runtime.operators.joins.spatial.utils.memory.SpatialJoinUtil;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class IntersectSpatialJoinUtil
implements ISpatialJoinUtil {
    protected final int[] idBuild;
    protected final int[] idProbe;

    public IntersectSpatialJoinUtil(int[] idBuild, int[] idProbe) {
        this.idBuild = idBuild;
        this.idProbe = idProbe;
    }

    @Override
    public boolean checkToSaveInMemory(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) throws HyracksDataException {
        int buildTileId = SpatialJoinUtil.getTileId(buildAccessor, buildTupleIndex, this.idBuild[0]);
        int probeTileId = SpatialJoinUtil.getTileId(probeAccessor, probeTupleIndex, this.idProbe[0]);
        double buildXmin = SpatialJoinUtil.getRectangleXmin(buildAccessor, buildTupleIndex, this.idBuild[1]);
        double probeXmax = SpatialJoinUtil.getRectangleXmax(probeAccessor, probeTupleIndex, this.idProbe[1]);
        if (buildTileId == probeTileId) {
            return buildXmin < probeXmax;
        }
        return false;
    }

    @Override
    public boolean checkToRemoveInMemory(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) throws HyracksDataException {
        int buildTileId = SpatialJoinUtil.getTileId(buildAccessor, buildTupleIndex, this.idBuild[0]);
        int probeTileId = SpatialJoinUtil.getTileId(probeAccessor, probeTupleIndex, this.idProbe[0]);
        double buildXmin = SpatialJoinUtil.getRectangleXmin(buildAccessor, buildTupleIndex, this.idBuild[1]);
        double probeXmax = SpatialJoinUtil.getRectangleXmax(probeAccessor, probeTupleIndex, this.idProbe[1]);
        if (buildTileId != probeTileId) {
            return true;
        }
        return buildXmin >= probeXmax;
    }

    @Override
    public boolean checkToSaveInResult(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) throws HyracksDataException {
        int buildTileId = SpatialJoinUtil.getTileId(buildAccessor, buildTupleIndex, this.idBuild[0]);
        int probeTileId = SpatialJoinUtil.getTileId(probeAccessor, probeTupleIndex, this.idProbe[0]);
        ARectangle rectBuild = SpatialJoinUtil.getRectangle(buildAccessor, buildTupleIndex, this.idBuild[1]);
        ARectangle rectProbe = SpatialJoinUtil.getRectangle(probeAccessor, probeTupleIndex, this.idProbe[1]);
        if (buildTileId == probeTileId) {
            return this.compareRectangle(rectBuild, rectProbe);
        }
        return false;
    }

    @Override
    public boolean checkForEarlyExit(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) throws HyracksDataException {
        int buildTileId = SpatialJoinUtil.getTileId(buildAccessor, buildTupleIndex, this.idBuild[0]);
        int probeTileId = SpatialJoinUtil.getTileId(probeAccessor, probeTupleIndex, this.idProbe[0]);
        double probeXmin = SpatialJoinUtil.getRectangleXmin(probeAccessor, probeTupleIndex, this.idProbe[1]);
        double buildXmax = SpatialJoinUtil.getRectangleXmax(buildAccessor, buildTupleIndex, this.idBuild[1]);
        if (buildTileId != probeTileId) {
            return true;
        }
        return buildXmax < probeXmin;
    }

    @Override
    public boolean compareRectangle(ARectangle rectBuild, ARectangle rectProbe) {
        return SpatialUtils.intersects(rectBuild, rectProbe);
    }

    @Override
    public boolean checkToLoadNextProbeTuple(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) throws HyracksDataException {
        int buildTileId = SpatialJoinUtil.getTileId(buildAccessor, buildTupleIndex, this.idBuild[0]);
        int probeTileId = SpatialJoinUtil.getTileId(probeAccessor, probeTupleIndex, this.idProbe[0]);
        double probeXmin = SpatialJoinUtil.getRectangleXmin(probeAccessor, probeTupleIndex, this.idProbe[1]);
        double buildXmax = SpatialJoinUtil.getRectangleXmax(buildAccessor, buildTupleIndex, this.idBuild[1]);
        if (buildTileId == probeTileId) {
            return buildXmax > probeXmin;
        }
        return buildTileId >= probeTileId;
    }
}

