/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.http.api.IServletRequest;

public class BaseRequest
implements IServletRequest {
    private static final List<String> NO_PARAM = Collections.singletonList(null);
    private final Channel channel;
    protected final FullHttpRequest request;
    protected final Map<? extends CharSequence, List<String>> parameters;
    protected final HttpScheme scheme;

    public static IServletRequest create(ChannelHandlerContext ctx, FullHttpRequest request, HttpScheme scheme, boolean ignoreQueryParameters) {
        Map param = ignoreQueryParameters ? Collections.emptyMap() : new QueryStringDecoder(request.uri()).parameters();
        return new BaseRequest(ctx.channel(), request, param, scheme);
    }

    protected BaseRequest(Channel channel, FullHttpRequest request, Map<? extends CharSequence, List<String>> parameters, HttpScheme scheme) {
        this.channel = channel;
        this.request = request;
        this.parameters = parameters;
        this.scheme = scheme;
    }

    @Override
    public FullHttpRequest getHttpRequest() {
        return this.request;
    }

    @Override
    public String getParameter(CharSequence name) {
        return this.parameters.getOrDefault(name, NO_PARAM).get(0);
    }

    @Override
    public List<String> getParameterValues(CharSequence name) {
        return Collections.unmodifiableList(this.parameters.getOrDefault(name, Collections.emptyList()));
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> names = new HashSet<String>();
        this.parameters.keySet().forEach(name -> names.add(name.toString()));
        return names;
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.parameters.forEach((name, values) -> paramMap.put(name.toString(), (String)values.get(0)));
        return paramMap;
    }

    @Override
    public Map<String, List<String>> getParametersValues() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        this.parameters.forEach((name, values) -> params.put(name.toString(), new ArrayList(values)));
        return params;
    }

    @Override
    public String getHeader(CharSequence name) {
        return this.request.headers().get(name);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public HttpScheme getScheme() {
        return this.scheme;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }
}

