/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.result.fields;

import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.result.ResponseMetrics;
import org.apache.asterix.common.api.Duration;
import org.apache.asterix.common.api.IResponseFieldPrinter;

public class MetricsPrinter
implements IResponseFieldPrinter {
    public static final String FIELD_NAME = "metrics";
    private final ResponseMetrics metrics;
    private final Charset resultCharset;

    public MetricsPrinter(ResponseMetrics metrics, Charset resultCharset) {
        this.metrics = metrics;
        this.resultCharset = resultCharset;
    }

    public void print(PrintWriter pw) {
        boolean useAscii = !StandardCharsets.UTF_8.equals(this.resultCharset) && !"\u03bc".contentEquals(this.resultCharset.decode(this.resultCharset.encode("\u03bc")));
        pw.print("\t\"");
        pw.print(FIELD_NAME);
        pw.print("\": {\n");
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.ELAPSED_TIME.str(), Duration.formatNanos((long)this.metrics.getElapsedTime(), (boolean)useAscii));
        pw.print("\n\t");
        ResultUtil.printField(pw, Metrics.EXECUTION_TIME.str(), Duration.formatNanos((long)this.metrics.getExecutionTime(), (boolean)useAscii));
        pw.print("\n\t");
        ResultUtil.printField(pw, Metrics.COMPILE_TIME.str(), Duration.formatNanos((long)this.metrics.getCompileTime(), (boolean)useAscii));
        pw.print("\n\t");
        ResultUtil.printField(pw, Metrics.QUEUE_WAIT_TIME.str(), Duration.formatNanos((long)this.metrics.getQueueWaitTime(), (boolean)useAscii));
        pw.print("\n\t");
        ResultUtil.printField(pw, Metrics.RESULT_COUNT.str(), this.metrics.getResultCount(), true);
        pw.print("\n\t");
        ResultUtil.printField(pw, Metrics.RESULT_SIZE.str(), this.metrics.getResultSize(), true);
        pw.print("\n\t");
        boolean hasErrors = this.metrics.getErrorCount() > 0L;
        boolean hasWarnings = this.metrics.getWarnCount() > 0L;
        boolean usedCache = !Double.isNaN(this.metrics.getBufferCacheHitRatio());
        ResultUtil.printField(pw, Metrics.PROCESSED_OBJECTS_COUNT.str(), this.metrics.getProcessedObjects(), usedCache || hasWarnings || hasErrors);
        pw.print("\n");
        if (usedCache) {
            pw.print("\t");
            String pctValue = String.format("%.2f%%", this.metrics.getBufferCacheHitRatio() * 100.0);
            ResultUtil.printField(pw, Metrics.BUFFERCACHE_HIT_RATIO.str(), pctValue, hasWarnings || hasErrors);
            pw.print("\n");
        }
        if (hasWarnings) {
            pw.print("\t");
            ResultUtil.printField(pw, Metrics.WARNING_COUNT.str(), this.metrics.getWarnCount(), hasErrors);
            pw.print("\n");
        }
        if (hasErrors) {
            pw.print("\t");
            ResultUtil.printField(pw, Metrics.ERROR_COUNT.str(), this.metrics.getErrorCount(), false);
            pw.print("\n");
        }
        pw.print("\t}");
    }

    public String getName() {
        return FIELD_NAME;
    }

    public static enum Metrics {
        ELAPSED_TIME("elapsedTime"),
        EXECUTION_TIME("executionTime"),
        COMPILE_TIME("compileTime"),
        QUEUE_WAIT_TIME("queueWaitTime"),
        RESULT_COUNT("resultCount"),
        RESULT_SIZE("resultSize"),
        ERROR_COUNT("errorCount"),
        PROCESSED_OBJECTS_COUNT("processedObjects"),
        WARNING_COUNT("warningCount"),
        BUFFERCACHE_HIT_RATIO("bufferCacheHitRatio");

        private final String str;

        private Metrics(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }
}

