/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.x509.type;

import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.ExplicitField;
import org.apache.kerby.asn1.ImplicitField;
import org.apache.kerby.asn1.type.Asn1BitString;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1SequenceType;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.x500.type.Name;
import org.apache.kerby.x509.type.AlgorithmIdentifier;
import org.apache.kerby.x509.type.AttCertValidityPeriod;
import org.apache.kerby.x509.type.CertificateSerialNumber;
import org.apache.kerby.x509.type.Extensions;
import org.apache.kerby.x509.type.SubjectPublicKeyInfo;

public class TBSCertificate
extends Asn1SequenceType {
    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField((EnumType)TBSCertificateField.VERSION, Asn1Integer.class), new Asn1FieldInfo((EnumType)TBSCertificateField.SERIAL_NUMBER, CertificateSerialNumber.class), new Asn1FieldInfo((EnumType)TBSCertificateField.SIGNATURE, AlgorithmIdentifier.class), new Asn1FieldInfo((EnumType)TBSCertificateField.ISSUER, Name.class), new Asn1FieldInfo((EnumType)TBSCertificateField.VALIDITY, AttCertValidityPeriod.class), new Asn1FieldInfo((EnumType)TBSCertificateField.SUBJECT, Name.class), new Asn1FieldInfo((EnumType)TBSCertificateField.SUBJECT_PUBLIC_KEY_INFO, SubjectPublicKeyInfo.class), new ImplicitField((EnumType)TBSCertificateField.ISSUER_UNIQUE_ID, 1, Asn1BitString.class), new ImplicitField((EnumType)TBSCertificateField.SUBJECT_UNIQUE_ID, 2, Asn1BitString.class), new ExplicitField((EnumType)TBSCertificateField.EXTENSIONS, 3, Extensions.class)};

    public TBSCertificate() {
        super(fieldInfos);
    }

    public int getVersion() {
        return this.getFieldAsInteger(TBSCertificateField.VERSION);
    }

    public void setVersion(int version) {
        this.setFieldAsInt(TBSCertificateField.VERSION, version);
    }

    public CertificateSerialNumber getSerialNumber() {
        return (CertificateSerialNumber)this.getFieldAs(TBSCertificateField.SERIAL_NUMBER, CertificateSerialNumber.class);
    }

    public void setSerialNumber(CertificateSerialNumber certificateSerialNumber) {
        this.setFieldAs(TBSCertificateField.SERIAL_NUMBER, (Asn1Type)certificateSerialNumber);
    }

    public AlgorithmIdentifier getSignature() {
        return (AlgorithmIdentifier)this.getFieldAs(TBSCertificateField.SIGNATURE, AlgorithmIdentifier.class);
    }

    public void setSignature(AlgorithmIdentifier signature) {
        this.setFieldAs(TBSCertificateField.SIGNATURE, (Asn1Type)signature);
    }

    public Name getIssuer() {
        return (Name)this.getFieldAs(TBSCertificateField.ISSUER, Name.class);
    }

    public void setIssuer(Name attCertIssuer) {
        this.setFieldAs(TBSCertificateField.ISSUER, (Asn1Type)attCertIssuer);
    }

    public AttCertValidityPeriod getValidity() {
        return (AttCertValidityPeriod)this.getFieldAs(TBSCertificateField.VALIDITY, AttCertValidityPeriod.class);
    }

    public void setValidity(AttCertValidityPeriod validity) {
        this.setFieldAs(TBSCertificateField.VALIDITY, (Asn1Type)validity);
    }

    public Name getSubject() {
        return (Name)this.getFieldAs(TBSCertificateField.SUBJECT, Name.class);
    }

    public void setSubject(Name subject) {
        this.setFieldAs(TBSCertificateField.SUBJECT, (Asn1Type)subject);
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return (SubjectPublicKeyInfo)this.getFieldAs(TBSCertificateField.SUBJECT_PUBLIC_KEY_INFO, SubjectPublicKeyInfo.class);
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.setFieldAs(TBSCertificateField.SUBJECT_PUBLIC_KEY_INFO, (Asn1Type)subjectPublicKeyInfo);
    }

    public byte[] getIssuerUniqueID() {
        return (byte[])((Asn1BitString)this.getFieldAs(TBSCertificateField.ISSUER_UNIQUE_ID, Asn1BitString.class)).getValue();
    }

    public void setIssuerUniqueId(byte[] issuerUniqueId) {
        this.setFieldAs(TBSCertificateField.ISSUER_UNIQUE_ID, (Asn1Type)new Asn1BitString(issuerUniqueId));
    }

    public byte[] getSubjectUniqueId() {
        return (byte[])((Asn1BitString)this.getFieldAs(TBSCertificateField.ISSUER_UNIQUE_ID, Asn1BitString.class)).getValue();
    }

    public void setSubjectUniqueId(byte[] issuerUniqueId) {
        this.setFieldAs(TBSCertificateField.SUBJECT_UNIQUE_ID, (Asn1Type)new Asn1BitString(issuerUniqueId));
    }

    public Extensions getExtensions() {
        return (Extensions)this.getFieldAs(TBSCertificateField.EXTENSIONS, Extensions.class);
    }

    public void setExtensions(Extensions extensions) {
        this.setFieldAs(TBSCertificateField.EXTENSIONS, (Asn1Type)extensions);
    }

    protected static enum TBSCertificateField implements EnumType
    {
        VERSION,
        SERIAL_NUMBER,
        SIGNATURE,
        ISSUER,
        VALIDITY,
        SUBJECT,
        SUBJECT_PUBLIC_KEY_INFO,
        ISSUER_UNIQUE_ID,
        SUBJECT_UNIQUE_ID,
        EXTENSIONS;


        public int getValue() {
            return this.ordinal();
        }

        public String getName() {
            return this.name();
        }
    }
}

