/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.List;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;

public abstract class AbstractDistinctByPOperator
extends AbstractPhysicalOperator {
    protected List<LogicalVariable> columnList;

    protected AbstractDistinctByPOperator(List<LogicalVariable> columnList) {
        this.columnList = columnList;
    }

    public List<LogicalVariable> getDistinctByColumns() {
        return this.columnList;
    }

    public void setDistinctByColumns(List<LogicalVariable> distinctByColumns) {
        this.columnList = distinctByColumns;
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return true;
    }

    protected int[] getKeysAndDecs(IOperatorSchema inputSchema) {
        int i;
        int[] keys = JobGenHelper.variablesToFieldIndexes(this.columnList, inputSchema);
        int sz = inputSchema.getSize();
        int fdSz = sz - this.columnList.size();
        int[] fdColumns = new int[fdSz];
        int j = 0;
        for (LogicalVariable v : inputSchema) {
            if (this.columnList.contains(v)) continue;
            fdColumns[j++] = inputSchema.findVariable(v);
        }
        int[] keysAndDecs = new int[keys.length + fdColumns.length];
        for (i = 0; i < keys.length; ++i) {
            keysAndDecs[i] = keys[i];
        }
        for (i = 0; i < fdColumns.length; ++i) {
            keysAndDecs[i + keys.length] = fdColumns[i];
        }
        return keysAndDecs;
    }
}

