/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorDelegate;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class DelegateOperator
extends AbstractLogicalOperator {
    private IOperatorDelegate delegate;

    public DelegateOperator(IOperatorDelegate delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate cannot be null!");
        }
        this.delegate = delegate;
        this.setExecutionMode(delegate.getExecutionMode());
    }

    @Override
    public void recomputeSchema() throws AlgebricksException {
        this.schema = new ArrayList<LogicalVariable>(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
        this.delegate.setSchema(this.schema);
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform transform) throws AlgebricksException {
        return this.delegate.acceptExpressionTransform(transform);
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitDelegateOperator(this, arg);
    }

    @Override
    public boolean isMap() {
        return this.delegate.isMap();
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return VariablePropagationPolicy.ALL;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.DELEGATE_OPERATOR;
    }

    public IOperatorDelegate getNewInstanceOfDelegateOperator() {
        return this.delegate.newInstance();
    }

    @Override
    public List<LogicalVariable> getSchema() {
        return this.schema;
    }

    @Override
    public AbstractLogicalOperator.ExecutionMode getExecutionMode() {
        return this.delegate.getExecutionMode();
    }

    @Override
    public void setExecutionMode(AbstractLogicalOperator.ExecutionMode mode) {
        this.delegate.setExecutionMode(mode);
    }

    @Override
    public IPhysicalOperator getPhysicalOperator() {
        return this.delegate.getPhysicalOperator();
    }

    @Override
    public IVariableTypeEnvironment computeInputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public IOperatorDelegate getDelegate() {
        return this.delegate;
    }
}

