/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.pushdown.ExpectedSchemaNodeToIATypeTranslatorVisitor;
import org.apache.asterix.optimizer.rules.pushdown.ExpressionValueAccessPushdownVisitor;
import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractComplexExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.AnyExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ArrayExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ObjectExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.UnionExpectedSchemaNode;
import org.apache.asterix.runtime.projection.DataProjectionInfo;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;

class ExpectedSchemaBuilder {
    private final Map<LogicalVariable, IExpectedSchemaNode> varToNode = new HashMap<LogicalVariable, IExpectedSchemaNode>();
    private final ExpectedSchemaNodeToIATypeTranslatorVisitor typeBuilder = new ExpectedSchemaNodeToIATypeTranslatorVisitor();

    public DataProjectionInfo createProjectionInfo(LogicalVariable recordVariable) {
        IExpectedSchemaNode rootNode = this.varToNode.get(recordVariable);
        HashMap<String, FunctionCallInformation> sourceInformation = new HashMap<String, FunctionCallInformation>();
        this.typeBuilder.reset(sourceInformation);
        ARecordType recordType = (ARecordType)rootNode.accept(this.typeBuilder, null);
        return new DataProjectionInfo(recordType, sourceInformation);
    }

    public boolean setSchemaFromExpression(AbstractFunctionCallExpression expr, LogicalVariable producedVar) {
        AbstractComplexExpectedSchemaNode parent = (AbstractComplexExpectedSchemaNode)this.buildNestedNode((ILogicalExpression)expr);
        if (parent != null) {
            AnyExpectedSchemaNode leaf = new AnyExpectedSchemaNode(parent, expr.getSourceLocation(), expr.getFunctionIdentifier().getName());
            this.addChild(expr, parent, leaf);
            if (producedVar != null) {
                this.varToNode.put(producedVar, leaf);
            }
        }
        return parent != null;
    }

    public void registerDataset(LogicalVariable recordVar, RootExpectedSchemaNode rootNode) {
        this.varToNode.put(recordVar, rootNode);
    }

    public void unregisterVariable(LogicalVariable variable) {
        IExpectedSchemaNode node = this.varToNode.remove(variable);
        AbstractComplexExpectedSchemaNode parent = node.getParent();
        if (parent == null) {
            this.varToNode.put(variable, RootExpectedSchemaNode.ALL_FIELDS_ROOT_NODE);
        } else {
            node.replaceIfNeeded(ExpectedSchemaNodeType.ANY, parent.getSourceLocation(), parent.getFunctionName());
        }
    }

    public boolean isVariableRegistered(LogicalVariable recordVar) {
        return this.varToNode.containsKey(recordVar);
    }

    public boolean containsRegisteredDatasets() {
        return !this.varToNode.isEmpty();
    }

    private IExpectedSchemaNode buildNestedNode(ILogicalExpression expr) {
        AbstractFunctionCallExpression myExpr = (AbstractFunctionCallExpression)expr;
        if (!ExpressionValueAccessPushdownVisitor.SUPPORTED_FUNCTIONS.contains(myExpr.getFunctionIdentifier())) {
            return null;
        }
        ILogicalExpression parentExpr = (ILogicalExpression)((Mutable)myExpr.getArguments().get(0)).getValue();
        if (ExpectedSchemaBuilder.isVariable(parentExpr)) {
            LogicalVariable sourceVar = VariableUtilities.getVariable((ILogicalExpression)parentExpr);
            return this.changeNodeForVariable(sourceVar, myExpr);
        }
        AbstractComplexExpectedSchemaNode newParent = (AbstractComplexExpectedSchemaNode)this.buildNestedNode(parentExpr);
        if (newParent != null) {
            AbstractFunctionCallExpression parentFuncExpr = (AbstractFunctionCallExpression)parentExpr;
            ExpectedSchemaNodeType myType = ExpectedSchemaBuilder.getExpectedNestedNodeType(myExpr);
            AbstractComplexExpectedSchemaNode myNode = AbstractComplexExpectedSchemaNode.createNestedNode(myType, newParent, myExpr.getSourceLocation(), myExpr.getFunctionIdentifier().getName());
            this.addChild(parentFuncExpr, newParent, myNode);
            return myNode;
        }
        return null;
    }

    private IExpectedSchemaNode changeNodeForVariable(LogicalVariable sourceVar, AbstractFunctionCallExpression myExpr) {
        IExpectedSchemaNode oldNode = this.varToNode.get(sourceVar);
        if (oldNode == null) {
            return null;
        }
        ExpectedSchemaNodeType varExpectedType = ExpectedSchemaBuilder.getExpectedNestedNodeType(myExpr);
        IExpectedSchemaNode newNode = oldNode.replaceIfNeeded(varExpectedType, myExpr.getSourceLocation(), myExpr.getFunctionIdentifier().getName());
        this.varToNode.put(sourceVar, newNode);
        return newNode;
    }

    private void addChild(AbstractFunctionCallExpression parentExpr, AbstractComplexExpectedSchemaNode parent, IExpectedSchemaNode child) {
        switch (parent.getType()) {
            case OBJECT: {
                this.handleObject(parentExpr, parent, child);
                break;
            }
            case ARRAY: {
                this.handleArray(parent, child);
                break;
            }
            case UNION: {
                this.handleUnion(parentExpr, parent, child);
                break;
            }
            default: {
                throw new IllegalStateException("Node " + parent.getType() + " is not nested");
            }
        }
    }

    private void handleObject(AbstractFunctionCallExpression parentExpr, AbstractComplexExpectedSchemaNode parent, IExpectedSchemaNode child) {
        ObjectExpectedSchemaNode objectNode = (ObjectExpectedSchemaNode)parent;
        objectNode.addChild(ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)parentExpr, (int)1), child);
    }

    private void handleArray(AbstractComplexExpectedSchemaNode parent, IExpectedSchemaNode child) {
        ArrayExpectedSchemaNode arrayNode = (ArrayExpectedSchemaNode)parent;
        arrayNode.addChild(child);
    }

    private void handleUnion(AbstractFunctionCallExpression parentExpr, AbstractComplexExpectedSchemaNode parent, IExpectedSchemaNode child) {
        UnionExpectedSchemaNode unionNode = (UnionExpectedSchemaNode)parent;
        ExpectedSchemaNodeType parentType = ExpectedSchemaBuilder.getExpectedNestedNodeType(parentExpr);
        this.addChild(parentExpr, unionNode.getChild(parentType), child);
    }

    private static ExpectedSchemaNodeType getExpectedNestedNodeType(AbstractFunctionCallExpression funcExpr) {
        FunctionIdentifier fid = funcExpr.getFunctionIdentifier();
        if (BuiltinFunctions.FIELD_ACCESS_BY_NAME.equals((Object)fid)) {
            return ExpectedSchemaNodeType.OBJECT;
        }
        if (ExpressionValueAccessPushdownVisitor.ARRAY_FUNCTIONS.contains(fid)) {
            return ExpectedSchemaNodeType.ARRAY;
        }
        throw new IllegalStateException("Function " + fid + " should not be pushed down");
    }

    private static boolean isVariable(ILogicalExpression expr) {
        return expr.getExpressionTag() == LogicalExpressionTag.VARIABLE;
    }
}

