/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.List;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ILSMIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBloomFilterDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleReference;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class LSMBTreePointSearchCursor
extends EnforcedIndexCursor
implements ILSMIndexCursor {
    protected ITreeIndexCursor[] btreeCursors;
    protected final ILSMIndexOperationContext opCtx;
    protected ISearchOperationCallback searchCallback;
    protected RangePredicate predicate;
    protected boolean includeMutableComponent;
    protected int numBTrees;
    private BTree.BTreeAccessor[] btreeAccessors;
    protected BloomFilter[] bloomFilters;
    protected ILSMHarness lsmHarness;
    private boolean nextHasBeenCalled;
    protected boolean foundTuple;
    protected int foundIn = -1;
    protected ITupleReference frameTuple;
    protected List<ILSMComponent> operationalComponents;
    protected boolean resultOfSearchCallbackProceed = false;
    protected final long[] hashes = BloomFilter.createHashArray();
    protected boolean hashComputed = false;

    public LSMBTreePointSearchCursor(ILSMIndexOperationContext opCtx) {
        this.opCtx = opCtx;
    }

    public boolean doHasNext() throws HyracksDataException {
        if (this.nextHasBeenCalled) {
            return false;
        }
        if (this.foundTuple) {
            return true;
        }
        this.hashComputed = false;
        boolean reconciled = false;
        for (int i = 0; i < this.numBTrees; ++i) {
            if (!this.isSearchCandidate(i)) continue;
            this.btreeAccessors[i].search((IIndexCursor)this.btreeCursors[i], (ISearchPredicate)this.predicate);
            if (this.btreeCursors[i].hasNext()) {
                this.btreeCursors[i].next();
                if (!reconciled) {
                    this.resultOfSearchCallbackProceed = this.searchCallback.proceed(this.predicate.getLowKey());
                }
                if (reconciled || this.resultOfSearchCallbackProceed) {
                    if (((ILSMTreeTupleReference)this.btreeCursors[i].getTuple()).isAntimatter()) {
                        if (reconciled) {
                            this.searchCallback.cancel(this.predicate.getLowKey());
                        }
                        this.btreeCursors[i].close();
                        return false;
                    }
                    this.frameTuple = this.btreeCursors[i].getTuple();
                    this.foundTuple = true;
                    this.foundIn = i;
                    return true;
                }
                if (i == 0 && this.includeMutableComponent) {
                    this.btreeCursors[i].close();
                    this.searchCallback.reconcile(this.predicate.getLowKey());
                    reconciled = true;
                    this.btreeAccessors[0].search((IIndexCursor)this.btreeCursors[i], (ISearchPredicate)this.predicate);
                    if (this.btreeCursors[i].hasNext()) {
                        this.btreeCursors[i].next();
                        if (((ILSMTreeTupleReference)this.btreeCursors[i].getTuple()).isAntimatter()) {
                            this.searchCallback.cancel(this.predicate.getLowKey());
                            this.btreeCursors[i].close();
                            return false;
                        }
                        this.frameTuple = this.btreeCursors[i].getTuple();
                        this.foundTuple = true;
                        this.searchCallback.complete(this.predicate.getLowKey());
                        this.foundIn = i;
                        return true;
                    }
                    this.searchCallback.cancel(this.predicate.getLowKey());
                    this.btreeCursors[i].close();
                    continue;
                }
                this.frameTuple = this.btreeCursors[i].getTuple();
                this.searchCallback.reconcile(this.frameTuple);
                this.searchCallback.complete(this.frameTuple);
                this.foundTuple = true;
                this.foundIn = i;
                return true;
            }
            this.btreeCursors[i].close();
        }
        return false;
    }

    protected boolean isSearchCandidate(int componentIndex) throws HyracksDataException {
        if (this.bloomFilters[componentIndex] != null) {
            if (!this.hashComputed) {
                this.bloomFilters[componentIndex].computeHashes(this.predicate.getLowKey(), this.hashes);
                this.hashComputed = true;
            }
            return this.bloomFilters[componentIndex].contains(this.hashes);
        }
        return true;
    }

    public void doClose() throws HyracksDataException {
        try {
            this.closeCursors();
            this.nextHasBeenCalled = false;
            this.foundTuple = false;
            this.hashComputed = false;
        }
        finally {
            if (this.lsmHarness != null) {
                this.lsmHarness.endSearch(this.opCtx);
            }
        }
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMBTreeCursorInitialState lsmInitialState = (LSMBTreeCursorInitialState)initialState;
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.searchCallback = lsmInitialState.getSearchOperationCallback();
        this.predicate = (RangePredicate)lsmInitialState.getSearchPredicate();
        this.numBTrees = this.operationalComponents.size();
        if (this.btreeCursors != null && this.btreeCursors.length != this.numBTrees) {
            Throwable failure = CleanupUtils.destroy(null, (IDestroyable[])this.btreeCursors);
            this.btreeCursors = null;
            failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])this.btreeAccessors);
            this.btreeAccessors = null;
            if (failure != null) {
                throw HyracksDataException.create((Throwable)failure);
            }
        }
        if (this.btreeCursors == null) {
            this.btreeCursors = new ITreeIndexCursor[this.numBTrees];
            this.btreeAccessors = new BTree.BTreeAccessor[this.numBTrees];
            this.bloomFilters = new BloomFilter[this.numBTrees];
        }
        this.includeMutableComponent = false;
        for (int i = 0; i < this.numBTrees; ++i) {
            ILSMComponent component = this.operationalComponents.get(i);
            BTree btree = (BTree)component.getIndex();
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                this.includeMutableComponent = true;
                if (this.bloomFilters[i] != null) {
                    this.destroyAndNullifyCursorAtIndex(i);
                }
            } else {
                if (this.bloomFilters[i] == null) {
                    this.destroyAndNullifyCursorAtIndex(i);
                }
                this.bloomFilters[i] = ((LSMBTreeWithBloomFilterDiskComponent)component).getBloomFilter();
            }
            if (this.btreeAccessors[i] == null) {
                this.btreeAccessors[i] = btree.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                this.btreeCursors[i] = this.btreeAccessors[i].createPointCursor(false, false);
                continue;
            }
            this.btreeAccessors[i].reset(btree, (IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            this.btreeCursors[i].close();
        }
        this.nextHasBeenCalled = false;
        this.foundTuple = false;
        this.hashComputed = false;
    }

    private void destroyAndNullifyCursorAtIndex(int i) throws HyracksDataException {
        this.bloomFilters[i] = null;
        Throwable failure = CleanupUtils.destroy(null, (IDestroyable[])new IDestroyable[]{this.btreeCursors[i]});
        this.btreeCursors[i] = null;
        failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])new IDestroyable[]{this.btreeAccessors[i]});
        this.btreeAccessors[i] = null;
        if (failure != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    public void doNext() throws HyracksDataException {
        this.nextHasBeenCalled = true;
    }

    public void doDestroy() throws HyracksDataException {
        if (this.btreeCursors != null) {
            for (int i = 0; i < this.numBTrees; ++i) {
                if (this.btreeCursors[i] == null) continue;
                this.btreeCursors[i].destroy();
            }
        }
    }

    public ITupleReference doGetTuple() {
        return this.frameTuple;
    }

    public ITupleReference getFilterMinTuple() {
        ILSMComponentFilter filter = this.getFilter();
        return filter == null ? null : filter.getMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        ILSMComponentFilter filter = this.getFilter();
        return filter == null ? null : filter.getMaxTuple();
    }

    private ILSMComponentFilter getFilter() {
        if (this.foundTuple) {
            return this.operationalComponents.get(this.foundIn).getLSMComponentFilter();
        }
        return null;
    }

    protected void closeCursors() throws HyracksDataException {
        if (this.btreeCursors != null) {
            for (int i = 0; i < this.numBTrees; ++i) {
                if (this.btreeCursors[i] == null) continue;
                this.btreeCursors[i].close();
            }
        }
    }

    public boolean getSearchOperationCallbackProceedResult() {
        return this.resultOfSearchCallbackProceed;
    }
}

