// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package version

import (
	"fmt"
	"runtime"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestShort(t *testing.T) {
	ver := Short()
	expectedVersion := fmt.Sprintf("unknown-unknown-%s", runtime.Version())
	assert.Equal(t, expectedVersion, ver, "bad version")
}

func TestLong(t *testing.T) {
	ver := Long()
	expectedVersion := `Version: unknown
Git SHA: unknown
Go Version: %s
Building OS/Arch: unknown
Running OS/Arch: %s/%s
`
	expectedVersion = fmt.Sprintf(expectedVersion, runtime.Version(), runtime.GOOS, runtime.GOARCH)
	assert.Equal(t, expectedVersion, ver, "bad version")
}
