/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.ambari.logfeeder.docker.command;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommandExecutionHelper {

  public static CommandResponse executeCommand(List<String> commands, Map<String, String> envMap) throws Exception {
    ProcessBuilder processBuilder = new ProcessBuilder(commands);
    Map<String, String> env = processBuilder.environment();
    if (envMap != null) {
      env.putAll(envMap);
    }
    Process shell = processBuilder.start();

    BufferedReader stdInput = new BufferedReader(new InputStreamReader(shell.getInputStream()));
    BufferedReader stdError = new BufferedReader(new InputStreamReader(shell.getErrorStream()));
    List<String> stdOutLines = new ArrayList<>();
    StringBuilder errOut = new StringBuilder();
    String s = null;
    while ((s = stdInput.readLine()) != null) {
      stdOutLines.add(s);
    }
    while ((s = stdError.readLine()) != null) {
      errOut.append(s);
    }
    int exitCode = shell.waitFor();

    return new CommandResponse(exitCode, stdOutLines, errOut.toString());
  }
}
