/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2.util;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;

public abstract class RetriableCommand {
    private static Log LOG = LogFactory.getLog(RetriableCommand.class);
    private static final long DELAY_MILLISECONDS = 500L;
    private static final int MAX_RETRIES = 3;
    private RetryPolicy retryPolicy = RetryPolicies.exponentialBackoffRetry(3, 500L, TimeUnit.MILLISECONDS);
    protected String description;

    public RetriableCommand(String description) {
        this.description = description;
    }

    public RetriableCommand(String description, RetryPolicy retryPolicy) {
        this(description);
        this.setRetryPolicy(retryPolicy);
    }

    protected abstract Object doExecute(Object ... var1) throws Exception;

    public Object execute(Object ... arguments) throws Exception {
        int counter = 0;
        while (true) {
            try {
                return this.doExecute(arguments);
            }
            catch (Exception exception) {
                Exception latestException;
                LOG.error("Failure in Retriable command: " + this.description, exception);
                if (this.retryPolicy.shouldRetry(latestException = exception, ++counter)) continue;
                throw new IOException("Couldn't run retriable-command: " + this.description, latestException);
            }
            break;
        }
    }

    public RetriableCommand setRetryPolicy(RetryPolicy retryHandler) {
        this.retryPolicy = retryHandler;
        return this;
    }
}

