/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;

public class FileSink
implements MetricsSink {
    private static final String FILENAME_KEY = "filename";
    private PrintWriter writer;

    @Override
    public void init(SubsetConfiguration conf) {
        String filename = conf.getString(FILENAME_KEY);
        try {
            this.writer = filename == null ? new PrintWriter(new BufferedOutputStream(System.out)) : new PrintWriter(new FileWriter(new File(filename), true));
        }
        catch (Exception e) {
            throw new MetricsException("Error creating " + filename, e);
        }
    }

    @Override
    public void putMetrics(MetricsRecord record) {
        this.writer.print(record.timestamp());
        this.writer.print(" ");
        this.writer.print(record.context());
        this.writer.print(".");
        this.writer.print(record.name());
        String separator = ": ";
        for (MetricsTag tag : record.tags()) {
            this.writer.print(separator);
            separator = ", ";
            this.writer.print(tag.name());
            this.writer.print("=");
            this.writer.print(String.valueOf(tag.value()));
        }
        for (Metric metric : record.metrics()) {
            this.writer.print(separator);
            separator = ", ";
            this.writer.print(metric.name());
            this.writer.print("=");
            this.writer.print(metric.value());
        }
        this.writer.println();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }
}

