/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenRenewer;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;

public class HsftpFileSystem
extends HftpFileSystem {
    public static final Text TOKEN_KIND = new Text("HSFTP delegation");
    private static final DelegationTokenRenewer<HsftpFileSystem> dtRenewer = new DelegationTokenRenewer<HsftpFileSystem>(HsftpFileSystem.class);
    private static final HsftpDelegationTokenSelector hftpTokenSelector = new HsftpDelegationTokenSelector();

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        DelegationTokenFetcher.setupSsl(conf);
    }

    @Override
    protected int getDefaultPort() {
        return this.getConf().getInt("dfs.https.port", 50470);
    }

    @Override
    protected String getUnderlyingProtocol() {
        return "https";
    }

    @Override
    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        try {
            query = this.updateQuery(query);
            URL url = new URI(this.getUnderlyingProtocol(), null, this.nnAddr.getHostName(), this.nnAddr.getPort(), path, query, null).toURL();
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setHostnameVerifier(new DummyHostnameVerifier());
            return conn;
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    protected Token<DelegationTokenIdentifier> selectHftpDelegationToken() {
        Text serviceName = SecurityUtil.buildTokenService(this.nnAddr);
        return hftpTokenSelector.selectToken(serviceName, this.ugi.getTokens());
    }

    private static class HsftpDelegationTokenSelector
    extends AbstractDelegationTokenSelector<DelegationTokenIdentifier> {
        public HsftpDelegationTokenSelector() {
            super(TOKEN_KIND);
        }
    }

    @InterfaceAudience.Private
    public static class TokenManager
    extends HftpFileSystem.TokenManager {
        @Override
        public boolean handleKind(Text kind) {
            return kind.equals(TOKEN_KIND);
        }

        @Override
        protected String getUnderlyingProtocol() {
            return "https";
        }
    }

    protected static class DummyHostnameVerifier
    implements HostnameVerifier {
        protected DummyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

