/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

final class Unpaged
implements Pageable {
    private static final Pageable UNSORTED = new Unpaged(Sort.unsorted());
    private final Sort sort;

    Unpaged(Sort sort) {
        this.sort = sort;
    }

    static Pageable sorted(Sort sort) {
        return sort.isSorted() ? new Unpaged(sort) : UNSORTED;
    }

    @Override
    public boolean isPaged() {
        return false;
    }

    @Override
    public Pageable previousOrFirst() {
        return this;
    }

    @Override
    public Pageable next() {
        return this;
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public int getPageSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPageNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pageable first() {
        return this;
    }

    @Override
    public Pageable withPage(int pageNumber) {
        if (pageNumber == 0) {
            return this;
        }
        throw new UnsupportedOperationException();
    }
}

