/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.Secrets;
import org.springframework.cloud.vault.config.VaultConfigOperations;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.util.KeyValueDelegate;
import org.springframework.vault.core.util.PropertyTransformer;
import org.springframework.vault.support.JsonMapFlattener;
import org.springframework.vault.support.VaultResponse;

public class VaultConfigTemplate
implements VaultConfigOperations {
    private static final Log log = LogFactory.getLog(VaultConfigTemplate.class);
    private final VaultOperations vaultOperations;
    private final VaultProperties properties;
    private final KeyValueDelegate keyValueDelegate;

    public VaultConfigTemplate(VaultOperations vaultOperations, VaultProperties properties) {
        Assert.notNull((Object)vaultOperations, (String)"VaultOperations must not be null!");
        Assert.notNull((Object)properties, (String)"VaultProperties must not be null!");
        this.vaultOperations = vaultOperations;
        this.properties = properties;
        this.keyValueDelegate = new KeyValueDelegate(vaultOperations);
    }

    @Override
    public Secrets read(SecretBackendMetadata secretBackendMetadata) {
        Assert.notNull((Object)secretBackendMetadata, (String)"SecureBackendAccessor must not be null!");
        log.info((Object)String.format("Fetching config from Vault at: %s", secretBackendMetadata.getPath()));
        try {
            VaultResponse vaultResponse = this.keyValueDelegate.isVersioned(secretBackendMetadata.getPath()) ? this.keyValueDelegate.getSecret(secretBackendMetadata.getPath()) : this.vaultOperations.read(secretBackendMetadata.getPath());
            if (vaultResponse == null) {
                log.info((Object)String.format("Could not locate PropertySource: %s", "key not found"));
                return null;
            }
            Map data = JsonMapFlattener.flatten((Map)((Map)vaultResponse.getRequiredData()));
            PropertyTransformer propertyTransformer = secretBackendMetadata.getPropertyTransformer();
            data = propertyTransformer.transformProperties(data);
            return this.createSecrets(vaultResponse, data);
        }
        catch (VaultException e) {
            if (this.properties.isFailFast()) {
                throw new IllegalStateException("Could not locate PropertySource and the fail fast property is set, failing.", e);
            }
            log.warn((Object)String.format("Could not locate PropertySource: %s", e.getMessage()));
            return null;
        }
    }

    private Secrets createSecrets(VaultResponse vaultResponse, Map<String, Object> data) {
        Secrets secrets = new Secrets();
        secrets.setData(data);
        secrets.setAuth(vaultResponse.getAuth());
        secrets.setLeaseDuration(vaultResponse.getLeaseDuration());
        secrets.setMetadata(vaultResponse.getMetadata());
        secrets.setLeaseId(vaultResponse.getLeaseId());
        secrets.setRenewable(vaultResponse.isRenewable());
        secrets.setRequestId(vaultResponse.getRequestId());
        secrets.setWarnings(vaultResponse.getWarnings());
        secrets.setWrapInfo(vaultResponse.getWrapInfo());
        return secrets;
    }

    @Override
    public VaultOperations getVaultOperations() {
        return this.vaultOperations;
    }
}

