/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.util.List;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DB2zSqlAstTranslator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.DB2zIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.DB2zSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2zDialect
extends DB2Dialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(12, 1);
    static final DatabaseVersion DB2_LUW_VERSION = DB2Dialect.MINIMUM_VERSION;

    public DB2zDialect(DialectResolutionInfo info) {
        this(info.makeCopy());
        this.registerKeywords(info);
    }

    public DB2zDialect() {
        this(MINIMUM_VERSION);
    }

    public DB2zDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        if (this.getVersion().isSameOrAfter(12)) {
            CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
            functionFactory.listagg(null);
            functionFactory.inverseDistributionOrderedSetAggregates();
            functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        }
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        if (this.getVersion().isAfter(10)) {
            switch (sqlTypeCode) {
                case 2013: 
                case 2014: {
                    return "timestamp with time zone";
                }
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    public DatabaseVersion getDB2Version() {
        return DB2_LUW_VERSION;
    }

    @Override
    public String getCreateIndexString(boolean unique) {
        return unique ? "create unique where not null index" : "create index";
    }

    @Override
    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        return "";
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return this.getVersion().isAfter(10) ? TimeZoneSupport.NATIVE : TimeZoneSupport.NONE;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return DB2zSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from sysibm.syssequences";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return DB2zIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsSkipLocked() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("add_");
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("second");
                break;
            }
            case WEEK: {
                pattern.append("day");
                break;
            }
            case QUARTER: {
                pattern.append("month");
                break;
            }
            default: {
                pattern.append("?1");
            }
        }
        pattern.append("s(");
        String timestampExpression = unit.isDateUnit() ? (temporalType == TemporalType.TIME ? "timestamp('1970-01-01',?3)" : "?3") : (temporalType == TemporalType.DATE ? "cast(?3 as timestamp)" : "?3");
        pattern.append(timestampExpression);
        pattern.append(",");
        switch (unit) {
            case NANOSECOND: {
                pattern.append("(?2)/1e9");
                break;
            }
            case WEEK: {
                pattern.append("(?2)*7");
                break;
            }
            case QUARTER: {
                pattern.append("(?2)*3");
                break;
            }
            default: {
                pattern.append("?2");
            }
        }
        pattern.append(")");
        return pattern.toString();
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DB2zSqlAstTranslator(sessionFactory, statement, DB2zDialect.this.getVersion());
            }
        };
    }

    @Override
    public String rowId(String rowId) {
        return rowId == null || rowId.isEmpty() ? "rowid_" : rowId;
    }

    @Override
    public int rowIdSqlType() {
        return -8;
    }

    @Override
    public String getRowIdColumnString(String rowId) {
        return this.rowId(rowId) + " rowid not null generated always";
    }
}

