/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.HashMap;
import org.apache.tomcat.util.digester.Digester;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaResolver
implements EntityResolver {
    protected Digester digester;
    protected HashMap<String, String> entityValidator = new HashMap();
    protected String schemaExtension = "xsd";

    public SchemaResolver(Digester digester) {
        this.digester = digester;
    }

    public void register(String publicId, String entityURL) {
        String key = publicId;
        if (publicId.indexOf(this.schemaExtension) != -1) {
            key = publicId.substring(publicId.lastIndexOf(47) + 1);
        }
        this.entityValidator.put(key, entityURL);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (publicId != null) {
            this.digester.setPublicId(publicId);
        }
        String entityURL = null;
        if (publicId != null) {
            entityURL = this.entityValidator.get(publicId);
        }
        String key = null;
        if (entityURL == null && systemId != null) {
            key = systemId.substring(systemId.lastIndexOf(47) + 1);
            entityURL = this.entityValidator.get(key);
        }
        if (entityURL == null) {
            return null;
        }
        try {
            return new InputSource(entityURL);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }
}

