/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.factory;

import java.lang.reflect.Method;
import org.dozer.BeanFactory;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBBeanFactory
implements BeanFactory {
    private static final Logger log = LoggerFactory.getLogger(JAXBBeanFactory.class);
    private static final char INNER_CLASS_DELIMETER = '$';

    @Override
    public Object createBean(Object srcObj, Class<?> srcObjClass, String beanId) {
        log.debug("createBean(Object, Class, String) - start [{}]", (Object)beanId);
        int indexOf = beanId.indexOf(36);
        while (indexOf > 0) {
            beanId = beanId.substring(0, indexOf) + beanId.substring(indexOf + 1);
            log.debug("createBean(Object, Class, String) - HAS BEEN CHANGED TO  [{}]", (Object)beanId);
            indexOf = beanId.indexOf(36);
        }
        Class<?> objectFactory = MappingUtils.loadClass(beanId.substring(0, beanId.lastIndexOf(".")) + ".ObjectFactory");
        Object factory = ReflectionUtils.newInstance(objectFactory);
        Method method = null;
        try {
            method = ReflectionUtils.getMethod(objectFactory, "create" + beanId.substring(beanId.lastIndexOf(".") + 1), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
        Object returnObject = ReflectionUtils.invoke(method, factory, new Object[0]);
        log.debug("createBean(Object, Class, String) - end [{}]", (Object)returnObject.getClass().getName());
        Object result = returnObject;
        return result;
    }
}

