/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.query.SqlPredicate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

@ManagedDescription(value="IMap")
public class MapMBean
extends HazelcastMBean<IMap> {
    private AtomicLong totalAddedEntryCount = new AtomicLong();
    private AtomicLong totalRemovedEntryCount = new AtomicLong();
    private AtomicLong totalUpdatedEntryCount = new AtomicLong();
    private AtomicLong totalEvictedEntryCount = new AtomicLong();
    private final String listenerId;

    protected MapMBean(IMap managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = service.createObjectName("IMap", managedObject.getName());
        EntryListener entryListener = new EntryListener(){

            public void entryAdded(EntryEvent event) {
                MapMBean.this.totalAddedEntryCount.incrementAndGet();
            }

            public void entryRemoved(EntryEvent event) {
                MapMBean.this.totalRemovedEntryCount.incrementAndGet();
            }

            public void entryUpdated(EntryEvent event) {
                MapMBean.this.totalUpdatedEntryCount.incrementAndGet();
            }

            public void entryEvicted(EntryEvent event) {
                MapMBean.this.totalEvictedEntryCount.incrementAndGet();
            }
        };
        this.listenerId = managedObject.addEntryListener(entryListener, false);
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        try {
            ((IMap)this.managedObject).removeEntryListener(this.listenerId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ManagedAnnotation(value="clear", operation=true)
    @ManagedDescription(value="Clear Map")
    public void clear() {
        ((IMap)this.managedObject).clear();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="name of the map")
    public String getName() {
        return ((IMap)this.managedObject).getName();
    }

    @ManagedAnnotation(value="size")
    @ManagedDescription(value="size of the map")
    public int getSize() {
        return ((IMap)this.managedObject).size();
    }

    @ManagedAnnotation(value="config")
    @ManagedDescription(value="MapConfig")
    public String getConfig() {
        return this.service.instance.getConfig().getMapConfig(((IMap)this.managedObject).getName()).toString();
    }

    @ManagedAnnotation(value="totalAddedEntryCount")
    public long getTotalAddedEntryCount() {
        return this.totalAddedEntryCount.get();
    }

    @ManagedAnnotation(value="totalRemovedEntryCount")
    public long getTotalRemovedEntryCount() {
        return this.totalRemovedEntryCount.get();
    }

    @ManagedAnnotation(value="totalUpdatedEntryCount")
    public long getTotalUpdatedEntryCount() {
        return this.totalUpdatedEntryCount.get();
    }

    @ManagedAnnotation(value="totalEvictedEntryCount")
    public long getTotalEvictedEntryCount() {
        return this.totalEvictedEntryCount.get();
    }

    @ManagedAnnotation(value="values", operation=true)
    public String values(String query) {
        Collection coll;
        if (query != null && !query.isEmpty()) {
            SqlPredicate predicate = new SqlPredicate(query);
            coll = ((IMap)this.managedObject).values(predicate);
        } else {
            coll = ((IMap)this.managedObject).values();
        }
        StringBuilder buf = new StringBuilder();
        if (coll.size() == 0) {
            buf.append("Empty");
        } else {
            buf.append("[");
            for (Object obj : coll) {
                buf.append(obj);
                buf.append(", ");
            }
            buf.replace(buf.length() - 1, buf.length(), "]");
        }
        return buf.toString();
    }

    @ManagedAnnotation(value="entrySet", operation=true)
    public String entrySet(String query) {
        Set entrySet;
        if (query != null && !query.isEmpty()) {
            SqlPredicate predicate = new SqlPredicate(query);
            entrySet = ((IMap)this.managedObject).entrySet(predicate);
        } else {
            entrySet = ((IMap)this.managedObject).entrySet();
        }
        StringBuilder buf = new StringBuilder();
        if (entrySet.size() == 0) {
            buf.append("Empty");
        } else {
            buf.append("[");
            for (Map.Entry entry : entrySet) {
                buf.append("{key:");
                buf.append(entry.getKey());
                buf.append(", value:");
                buf.append(entry.getValue());
                buf.append("}, ");
            }
            buf.replace(buf.length() - 1, buf.length(), "]");
        }
        return buf.toString();
    }
}

