/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.AddAllOperation;
import com.hazelcast.collection.operations.client.CollectionKeyBasedRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AddAllRequest
extends CollectionKeyBasedRequest
implements InitializingObjectRequest {
    List<Data> dataList;
    int index = -1;
    int threadId = -1;

    public AddAllRequest() {
    }

    public AddAllRequest(CollectionProxyId proxyId, Data key, int threadId, List<Data> dataList) {
        super(proxyId, key);
        this.threadId = threadId;
        this.dataList = dataList;
    }

    public AddAllRequest(CollectionProxyId proxyId, Data key, int threadId, List<Data> dataList, int index) {
        super(proxyId, key);
        this.threadId = threadId;
        this.dataList = dataList;
        this.index = index;
    }

    @Override
    protected Operation prepareOperation() {
        return new AddAllOperation(this.proxyId, this.key, this.threadId, this.dataList, this.index);
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("i", this.index);
        writer.writeInt("t", this.threadId);
        writer.writeInt("s", this.dataList.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Data data : this.dataList) {
            data.writeData(out);
        }
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.index = reader.readInt("i");
        this.threadId = reader.readInt("t");
        int size = reader.readInt("s");
        this.dataList = new ArrayList<Data>(size);
        ObjectDataInput in = reader.getRawDataInput();
        for (int i = 0; i < size; ++i) {
            Data data = new Data();
            data.readData(in);
            this.dataList.add(data);
        }
        super.readPortable(reader);
    }
}

