/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap.tx;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.multimap.tx.TransactionLogKey;
import com.hazelcast.collection.multimap.tx.TxnCommitOperation;
import com.hazelcast.collection.multimap.tx.TxnPrepareOperation;
import com.hazelcast.collection.multimap.tx.TxnPutOperation;
import com.hazelcast.collection.multimap.tx.TxnRemoveAllOperation;
import com.hazelcast.collection.multimap.tx.TxnRemoveOperation;
import com.hazelcast.collection.multimap.tx.TxnRollbackOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.impl.KeyAwareTransactionLog;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;

public class MultiMapTransactionLog
implements KeyAwareTransactionLog {
    CollectionProxyId proxyId;
    final List<Operation> opList = new LinkedList<Operation>();
    Data key;
    long ttl;
    int threadId;
    long txVersion;

    public MultiMapTransactionLog() {
    }

    public MultiMapTransactionLog(Data key, CollectionProxyId proxyId, long ttl, int threadId, long version) {
        this.key = key;
        this.proxyId = proxyId;
        this.ttl = ttl;
        this.threadId = threadId;
        this.txVersion = version;
    }

    @Override
    public Future prepare(NodeEngine nodeEngine) {
        TxnPrepareOperation operation = new TxnPrepareOperation(this.proxyId, this.key, this.ttl, this.threadId);
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(this.key);
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:collectionService", (Operation)operation, partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Future commit(NodeEngine nodeEngine) {
        TxnCommitOperation operation = new TxnCommitOperation(this.proxyId, this.key, this.threadId, this.txVersion, this.opList);
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(this.key);
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:collectionService", (Operation)operation, partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Future rollback(NodeEngine nodeEngine) {
        TxnRollbackOperation operation = new TxnRollbackOperation(this.proxyId, this.key, this.threadId);
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(this.key);
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:collectionService", (Operation)operation, partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.proxyId.writeData(out);
        out.writeInt(this.opList.size());
        for (Operation op : this.opList) {
            out.writeObject(op);
        }
        this.key.writeData(out);
        out.writeLong(this.ttl);
        out.writeInt(this.threadId);
        out.writeLong(this.txVersion);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.proxyId = new CollectionProxyId();
        this.proxyId.readData(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.opList.add((Operation)in.readObject());
        }
        this.key = new Data();
        this.key.readData(in);
        this.ttl = in.readLong();
        this.threadId = in.readInt();
        this.txVersion = in.readLong();
    }

    @Override
    public Object getKey() {
        return new TransactionLogKey(this.proxyId, this.key);
    }

    public void addOperation(Operation op) {
        if (op instanceof TxnRemoveOperation) {
            TxnRemoveOperation removeOperation = (TxnRemoveOperation)op;
            Iterator<Operation> iter = this.opList.iterator();
            while (iter.hasNext()) {
                TxnPutOperation putOperation;
                Operation opp = iter.next();
                if (!(opp instanceof TxnPutOperation) || (putOperation = (TxnPutOperation)opp).getRecordId() != removeOperation.getRecordId()) continue;
                iter.remove();
                return;
            }
        } else if (op instanceof TxnRemoveAllOperation) {
            TxnRemoveAllOperation removeAllOperation = (TxnRemoveAllOperation)op;
            Collection<Long> recordIds = removeAllOperation.getRecordIds();
            Iterator<Operation> iter = this.opList.iterator();
            while (iter.hasNext()) {
                TxnPutOperation putOperation;
                Operation opp = iter.next();
                if (!(opp instanceof TxnPutOperation) || !recordIds.remove((putOperation = (TxnPutOperation)opp).getRecordId())) continue;
                iter.remove();
            }
            if (recordIds.isEmpty()) {
                return;
            }
        }
        this.opList.add(op);
    }

    public int size() {
        int size = 0;
        for (Operation operation : this.opList) {
            if (operation instanceof TxnRemoveAllOperation) {
                TxnRemoveAllOperation removeAllOperation = (TxnRemoveAllOperation)operation;
                size -= removeAllOperation.getRecordIds().size();
                continue;
            }
            if (operation instanceof TxnRemoveOperation) {
                --size;
                continue;
            }
            ++size;
        }
        return size;
    }
}

