/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.configuration;

import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FilePropertiesHelper
extends PropertiesHelper
implements Runnable {
    protected File file;
    protected long lastAccess;

    public FilePropertiesHelper(String prefix, String file, Map<String, PropertyMD> meta, Logger log) throws ConfigurationException, IOException {
        this(prefix, new File(file), meta, log);
    }

    public FilePropertiesHelper(String prefix, File file, Map<String, PropertyMD> meta, Logger log) throws ConfigurationException, IOException {
        super(prefix, FilePropertiesHelper.load(file), meta, log);
        this.file = file;
        this.lastAccess = file.lastModified();
    }

    public void reload() throws IOException, ConfigurationException {
        this.setProperties(FilePropertiesHelper.load(this.file));
    }

    public File getFile() {
        return this.file;
    }

    private boolean hasChanged() {
        return FilePropertiesHelper.hasFileChanged(this.lastAccess, this.file);
    }

    public boolean reloadIfChanged() throws IOException, ConfigurationException {
        if (this.hasChanged()) {
            this.reload();
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.reloadIfChanged();
        }
        catch (ConfigurationException e) {
            this.log.warn("The reloaded configuration is invalid: " + e.getMessage(), e);
        }
        catch (IOException e) {
            this.log.warn("Can't re-read the configuration file " + this.file + ": " + e.getMessage(), e);
        }
    }

    public static boolean hasFileChanged(long lastAccess, File file) {
        long fileMod = file.lastModified();
        boolean ret = lastAccess == 0L || lastAccess < fileMod;
        lastAccess = fileMod;
        return ret;
    }

    public static Properties load(String file) throws IOException {
        return FilePropertiesHelper.load(new File(file));
    }

    public static Properties load(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (Exception e) {
            throw new Error("Can not load properties file " + file + ": " + e.getMessage(), e);
        }
        finally {
            is.close();
        }
        return properties;
    }
}

