/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.validators;

import eu.unicore.samly2.SAMLBindings;
import eu.unicore.samly2.SAMLUtils;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.exceptions.SAMLValidationSoftException;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.samly2.validators.AssertionValidator;
import eu.unicore.samly2.validators.ErrorReasons;
import eu.unicore.samly2.validators.ReplayAttackChecker;
import eu.unicore.samly2.validators.SSOAuthnAssertionValidator;
import eu.unicore.samly2.validators.StatusResponseValidator;
import java.util.ArrayList;
import java.util.List;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;
import xmlbeans.org.oasis.saml2.protocol.ResponseType;

public class SSOAuthnResponseValidator
extends StatusResponseValidator {
    protected ReplayAttackChecker replayChecker;
    protected String consumerSamlName;
    protected long samlValidityGraceTime;
    protected SAMLBindings binding;
    protected List<AssertionDocument> authNAssertions;
    protected List<AssertionDocument> otherAssertions;
    protected ErrorReasons reasons;

    public SSOAuthnResponseValidator(String consumerSamlName, String consumerEndpointUri, String requestId, long samlValidityGraceTime, SamlTrustChecker trustChecker, ReplayAttackChecker replayChecker, SAMLBindings binding) {
        super(consumerEndpointUri, requestId, trustChecker);
        this.consumerSamlName = consumerSamlName;
        this.replayChecker = replayChecker;
        this.samlValidityGraceTime = samlValidityGraceTime;
        this.binding = binding;
    }

    public void validate(ResponseDocument authenticationResponseDoc) throws SAMLValidationException {
        AssertionDocument[] assertions;
        this.authNAssertions = new ArrayList<AssertionDocument>();
        this.otherAssertions = new ArrayList<AssertionDocument>();
        this.reasons = new ErrorReasons();
        ResponseType response = authenticationResponseDoc.getResponse();
        super.validate(authenticationResponseDoc, response);
        NameIDType issuer = response.getIssuer();
        if (issuer != null && issuer.getFormat() != null && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLValidationException("Issuer of SAML response must be of Entity type in SSO AuthN. It is: " + issuer.getFormat());
        }
        try {
            assertions = SAMLUtils.getAssertions(response);
        }
        catch (Exception e) {
            throw new SAMLValidationException("XML handling problem during retrieval of response assertions", e);
        }
        SSOAuthnAssertionValidator authnAsValidator = new SSOAuthnAssertionValidator(this.consumerSamlName, this.consumerEndpointUri, this.requestId, this.samlValidityGraceTime, this.trustChecker, this.replayChecker, this.binding);
        AssertionValidator asValidator = new AssertionValidator(this.consumerSamlName, this.consumerEndpointUri, null, this.samlValidityGraceTime, this.trustChecker);
        for (AssertionDocument assertionDoc : assertions) {
            AssertionType assertion = assertionDoc.getAssertion();
            if (assertion.sizeOfAuthnStatementArray() > 0) {
                this.tryValidateAsAuthnAssertion(authnAsValidator, assertionDoc);
            } else {
                this.tryValidateAsGenericAssertion(asValidator, assertionDoc);
            }
            if (issuer == null) {
                issuer = assertion.getIssuer();
                continue;
            }
            if (issuer.getStringValue().equals(assertion.getIssuer().getStringValue())) continue;
            throw new SAMLValidationException("Inconsistent issuer in assertion: " + assertion.getIssuer() + ", previously had: " + issuer);
        }
        if (this.authNAssertions.size() == 0) {
            if (this.reasons.getSize() > 0) {
                throw new SAMLValidationException("Authentication assertion(s) was found, but it was not correct wrt SSO profile: " + this.reasons);
            }
            throw new SAMLValidationException("There was no authentication assertion found in the SAML response");
        }
    }

    public List<AssertionDocument> getAuthNAssertions() {
        return this.authNAssertions;
    }

    public List<AssertionDocument> getOtherAssertions() {
        return this.otherAssertions;
    }

    protected void tryValidateAsAuthnAssertion(SSOAuthnAssertionValidator authnAsValidator, AssertionDocument assertionDoc) throws SAMLValidationException {
        try {
            authnAsValidator.validate(assertionDoc);
            this.authNAssertions.add(assertionDoc);
        }
        catch (SAMLValidationSoftException e) {
            this.reasons.addAssertionError(assertionDoc.getAssertion(), e.getMessage());
        }
    }

    protected void tryValidateAsGenericAssertion(AssertionValidator asValidator, AssertionDocument assertionDoc) throws SAMLValidationException {
        asValidator.validate(assertionDoc);
        AssertionType assertion = assertionDoc.getAssertion();
        NameIDType asIssuer = assertion.getIssuer();
        if (asIssuer.getFormat() != null && !asIssuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLValidationException("Issuer of assertion must be of Entity type in SSO AuthN. It is: " + asIssuer.getFormat());
        }
        if (this.binding == SAMLBindings.HTTP_POST && (assertion.getSignature() == null || assertion.getSignature().isNil())) {
            throw new SAMLValidationException("Assertion is not signed in the SSO authN used over HTTP POST, while should be.");
        }
        this.otherAssertions.add(assertionDoc);
    }
}

