/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans;

import eu.unicore.util.Log;
import java.util.Calendar;
import javax.xml.namespace.QName;
import javax.xml.ws.WebFault;
import org.apache.cxf.interceptor.FaultOutInterceptor;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultDocument;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultType;

@WebFault(name="BaseFault", targetNamespace="http://docs.oasis-open.org/wsrf/bf-2")
public class BaseFault
extends Exception
implements FaultOutInterceptor.FaultInfoException {
    protected static final long serialVersionUID = 1L;
    private BaseFaultType faultDetail;

    public BaseFault(String message, Throwable cause, BaseFaultType details) {
        super(message, cause);
        this.faultDetail = details;
    }

    public BaseFault(String message, BaseFaultType details) {
        super(message);
        this.faultDetail = details;
    }

    public BaseFault(String message) {
        super(message);
    }

    public BaseFaultType getFaultInfo() {
        return this.faultDetail;
    }

    public static QName getFaultName() {
        return BaseFaultDocument.type.getDocumentElementName();
    }

    public static BaseFault createFault(String message) {
        return BaseFault.createFault(message, null, false);
    }

    public static BaseFault createFault(String message, Throwable cause) {
        return BaseFault.createFault(message, cause, true);
    }

    public static BaseFault createFault(String message, Throwable cause, boolean addDetails) {
        BaseFaultType bft = BaseFaultType.Factory.newInstance();
        bft.setTimestamp(Calendar.getInstance());
        StringBuilder finalMsg = new StringBuilder();
        finalMsg.append(message);
        if (addDetails && cause != null) {
            finalMsg.append(" Reason: ").append(Log.getDetailMessage(cause));
        }
        bft.addNewDescription().setStringValue(finalMsg.toString());
        return cause == null ? new BaseFault(finalMsg.toString(), bft) : new BaseFault(finalMsg.toString(), cause, bft);
    }
}

