/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.lookup;

import de.fzj.unicore.uas.lookup.AddressFilter;
import de.fzj.unicore.uas.lookup.Producer;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class Lister<T extends BaseWSRFClient>
implements Iterable<T> {
    private volatile boolean running = false;
    private final BlockingQueue<T> queue;
    private long timeout = 100L;
    private TimeUnit unit = TimeUnit.MILLISECONDS;
    private final List<Producer<T>> producers = new ArrayList<Producer<T>>();
    private ExecutorService executor;
    private final AtomicInteger runCounter = new AtomicInteger(0);
    protected AddressFilter<T> addressFilter;

    public Lister(ExecutorService executor, AddressFilter<T> filter, int maxQueueSize) {
        this.executor = executor;
        this.addressFilter = filter != null ? filter : new AcceptAllFilter();
        this.queue = new LinkedBlockingQueue<T>(maxQueueSize);
    }

    public void setAddressFilter(AddressFilter<T> filter) {
        this.addressFilter = filter;
    }

    public AddressFilter<T> setAddressFilter() {
        return this.addressFilter;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.unit = timeUnit;
    }

    public void addProducer(Producer<T> producer) {
        this.producers.add(producer);
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public Iterator<T> iterator() {
        if (!this.running) {
            this.run();
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return Lister.this.running && (Lister.this.runCounter.get() > 0 || Lister.this.queue.size() > 0);
            }

            @Override
            public T next() {
                try {
                    return (BaseWSRFClient)Lister.this.queue.poll(Lister.this.timeout, Lister.this.unit);
                }
                catch (InterruptedException it) {
                    Lister.this.running = false;
                    return null;
                }
            }

            @Override
            public void remove() {
            }
        };
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        if (this.running) {
            throw new IllegalStateException();
        }
        if (this.producers.size() > 0) {
            this.running = true;
            this.runCounter.set(this.producers.size());
            for (Producer<T> p : this.producers) {
                p.init(this.queue, this.runCounter);
                if (this.executor != null) {
                    this.executor.execute(p);
                    continue;
                }
                p.run();
            }
        }
    }

    public static class AcceptAllFilter<T>
    implements AddressFilter<T> {
        @Override
        public boolean accept(EndpointReferenceType epr) {
            return true;
        }

        @Override
        public boolean accept(String uri) {
            return true;
        }

        @Override
        public boolean accept(T client) {
            return true;
        }
    }
}

