/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.openjpa.jdbc.kernel.exps.BinaryOpExpState;
import org.apache.openjpa.jdbc.kernel.exps.CompareEqualExpression;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.FilterValueImpl;
import org.apache.openjpa.jdbc.kernel.exps.Param;
import org.apache.openjpa.jdbc.kernel.exps.Type;
import org.apache.openjpa.jdbc.kernel.exps.TypeLit;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.meta.ClassMetaData;

class EqualTypeExpression
extends CompareEqualExpression {
    public EqualTypeExpression(Val val1, Val val2) {
        super(val1, val2);
    }

    private ClassMapping getSubClassMapping(Val val1, Val val2, ExpContext ctx) {
        Val val;
        ClassMapping sub = null;
        Val val3 = val = val1 instanceof Type ? val2 : val1;
        if (val instanceof TypeLit) {
            sub = (ClassMapping)val.getMetaData();
        } else if (val instanceof Param) {
            sub = ((Param)val).getValueMetaData(ctx);
        }
        if (sub != null) {
            ctx.isVerticalStrat = sub.isVerticalStrategy();
        }
        return sub;
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer buf) {
        Val val1 = this.getValue1();
        Val val2 = this.getValue2();
        ClassMapping sub = this.getSubClassMapping(val1, val2, ctx);
        if (ctx.isVerticalStrat) {
            this.appendTo(sel, ctx, (BinaryOpExpState)state, buf, false, false);
            return;
        }
        super.appendTo(sel, ctx, state, buf);
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, BinaryOpExpState bstate, SQLBuffer buf, boolean val1Null, boolean val2Null) {
        if (val1Null && val2Null) {
            buf.append("1 = 1");
        } else if (val1Null || val2Null) {
            ExpState state;
            Val val = val1Null ? this.getValue2() : this.getValue1();
            ExpState expState = state = val1Null ? bstate.state2 : bstate.state1;
            if (!this.isDirectComparison()) {
                int len = val.length(sel, ctx, state);
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        buf.append(" AND ");
                    }
                    val.appendTo(sel, ctx, state, buf, i);
                    buf.append(" IS ").appendValue(null);
                }
            } else {
                val.appendIsNull(sel, ctx, state, buf);
            }
        } else {
            Val val1 = this.getValue1();
            Val val2 = this.getValue2();
            if (val1.length(sel, ctx, bstate.state1) == 1 && val2.length(sel, ctx, bstate.state2) == 1) {
                ClassMapping sub = this.getSubClassMapping(val1, val2, ctx);
                if (ctx.isVerticalStrat) {
                    this.processVerticalTypeAppend(sel, val1, val2, ctx, buf);
                    return;
                }
                String op = "=";
                if (sel.getTablePerClassMeta() != null && sub != sel.getTablePerClassMeta()) {
                    op = "<>";
                }
                ctx.store.getDBDictionary().comparison(buf, op, new FilterValueImpl(sel, ctx, bstate.state1, val1), new FilterValueImpl(sel, ctx, bstate.state2, val2));
            } else {
                int len = Math.min(val1.length(sel, ctx, bstate.state1), val2.length(sel, ctx, bstate.state2));
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        buf.append(" AND ");
                    }
                    val1.appendTo(sel, ctx, bstate.state1, buf, i);
                    buf.append(" = ");
                    val2.appendTo(sel, ctx, bstate.state2, buf, i);
                }
            }
        }
    }

    void processVerticalTypeAppend(Select sel, Val val1, Val val2, ExpContext ctx, SQLBuffer buf) {
        ClassMapping sub = this.getSubClassMapping(val1, val2, ctx);
        ArrayList<ClassMetaData> selectFrom = sel.getJoinedTableClassMeta();
        if (selectFrom == null) {
            selectFrom = new ArrayList<ClassMetaData>();
            sel.setJoinedTableClassMeta(selectFrom);
        }
        ClassMapping cm1 = (ClassMapping)(val1 instanceof Type ? val1.getMetaData() : val1.getMetaData());
        if (sub.isVerticalStrategy()) {
            ClassMetaData[] subs = cm1.getPCSubclassMetaDatas();
            for (int i = 0; i < subs.length; ++i) {
                if (Modifier.isAbstract(subs[i].getDescribedType().getModifiers()) || subs[i] != sub || selectFrom.contains(subs[i])) continue;
                selectFrom.add(subs[i]);
            }
            buf.append("1=1");
            return;
        }
    }
}

