/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConcurrentMultivaluedHashMap<K, V>
extends ConcurrentHashMap<K, List<V>> {
    public void putSingle(K key, V value) {
        CopyOnWriteArrayList<V> list = new CopyOnWriteArrayList<V>();
        list.add(value);
        this.put(key, list);
    }

    public void addAll(K key, V ... newValues) {
        for (V value : newValues) {
            this.add(key, value);
        }
    }

    public void addAll(K key, List<V> valueList) {
        for (V value : valueList) {
            this.add(key, value);
        }
    }

    public void addFirst(K key, V value) {
        List list = (List)this.get(key);
        if (list == null) {
            this.add(key, value);
        } else {
            list.add(0, value);
        }
    }

    public final void add(K key, V value) {
        this.getList(key).add(value);
    }

    public final void addMultiple(K key, Collection<V> values) {
        this.getList(key).addAll(values);
    }

    public V getFirst(K key) {
        List list = (List)this.get(key);
        return list == null ? null : (V)list.get(0);
    }

    public final List<V> getList(K key) {
        CopyOnWriteArrayList list = (CopyOnWriteArrayList)this.get(key);
        if (list == null) {
            list = new CopyOnWriteArrayList();
            this.put(key, list);
        }
        return list;
    }

    public void addAll(ConcurrentMultivaluedHashMap<K, V> other) {
        for (Map.Entry entry : other.entrySet()) {
            this.getList(entry.getKey()).addAll((Collection)entry.getValue());
        }
    }
}

