/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.orchestrator.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription;
import org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference;
import org.apache.airavata.model.data.movement.DataMovementInterface;
import org.apache.airavata.model.data.movement.DataMovementProtocol;
import org.apache.airavata.model.data.movement.SCPDataMovement;
import org.apache.airavata.model.data.movement.SecurityProtocol;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.orchestrator.core.OrchestratorConfiguration;
import org.apache.airavata.orchestrator.core.context.OrchestratorContext;
import org.apache.airavata.orchestrator.core.exception.OrchestratorException;
import org.apache.airavata.registry.cpi.AppCatalog;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ApplicationInterface;
import org.apache.airavata.registry.cpi.GwyResourceProfile;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.UsrResourceProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrchestratorUtils {
    private static final Logger logger = LoggerFactory.getLogger(OrchestratorUtils.class);

    public static OrchestratorConfiguration loadOrchestratorConfiguration() throws OrchestratorException, IOException, NumberFormatException, ApplicationSettingsException {
        OrchestratorConfiguration orchestratorConfiguration = new OrchestratorConfiguration();
        orchestratorConfiguration.setSubmitterInterval(Integer.parseInt(ServerSettings.getSetting((String)"submitter.interval")));
        orchestratorConfiguration.setThreadPoolSize(Integer.parseInt(ServerSettings.getSetting((String)"threadpool.size")));
        orchestratorConfiguration.setStartSubmitter(Boolean.valueOf(ServerSettings.getSetting((String)"start.submitter")));
        orchestratorConfiguration.setEmbeddedMode(Boolean.valueOf(ServerSettings.getSetting((String)"embedded.mode")));
        orchestratorConfiguration.setEnableValidation(Boolean.valueOf(ServerSettings.getSetting((String)"enable.validation")));
        if (orchestratorConfiguration.isEnableValidation()) {
            orchestratorConfiguration.setValidatorClasses(Arrays.asList(ServerSettings.getSetting((String)"job.validators").split(",")));
        }
        return orchestratorConfiguration;
    }

    public static JobSubmissionProtocol getPreferredJobSubmissionProtocol(OrchestratorContext context, ProcessModel model, String gatewayId) throws RegistryException {
        try {
            String resourceHostId = model.getComputeResourceId();
            return OrchestratorUtils.getComputeResourcePreference(context, gatewayId, resourceHostId).getPreferredJobSubmissionProtocol();
        }
        catch (AppCatalogException e) {
            logger.error("Error occurred while initializing app catalog", (Throwable)e);
            throw new RegistryException("Error occurred while initializing app catalog", (Throwable)e);
        }
    }

    public static ComputeResourcePreference getComputeResourcePreference(OrchestratorContext context, String gatewayId, String resourceHostId) throws AppCatalogException, RegistryException {
        GwyResourceProfile gatewayProfile = OrchestratorUtils.getGatewayProfile(context);
        return gatewayProfile.getComputeResourcePreference(gatewayId, resourceHostId);
    }

    public static GwyResourceProfile getGatewayProfile(OrchestratorContext context) throws AppCatalogException, RegistryException {
        return context.getRegistry().getAppCatalog().getGatewayProfile();
    }

    public static UsrResourceProfile getUserResourceProfile(OrchestratorContext context) throws RegistryException, AppCatalogException {
        return context.getRegistry().getAppCatalog().getUserResourceProfile();
    }

    public static String getApplicationInterfaceName(OrchestratorContext context, ProcessModel model) throws RegistryException {
        try {
            ApplicationInterface applicationInterface = context.getRegistry().getAppCatalog().getApplicationInterface();
            ApplicationInterfaceDescription appInterface = applicationInterface.getApplicationInterface(model.getApplicationInterfaceId());
            return appInterface.getApplicationName();
        }
        catch (AppCatalogException e) {
            throw new RegistryException("Error while retrieving application interface", (Throwable)e);
        }
    }

    public static DataMovementProtocol getPreferredDataMovementProtocol(OrchestratorContext context, ProcessModel model, String gatewayId) throws RegistryException {
        try {
            String resourceHostId = model.getComputeResourceId();
            return OrchestratorUtils.getComputeResourcePreference(context, gatewayId, resourceHostId).getPreferredDataMovementProtocol();
        }
        catch (AppCatalogException e) {
            logger.error("Error occurred while initializing app catalog", (Throwable)e);
            throw new RegistryException("Error occurred while initializing app catalog", (Throwable)e);
        }
    }

    public static ComputeResourcePreference getComputeResourcePreference(OrchestratorContext context, ProcessModel processModel, String gatewayId) throws RegistryException {
        try {
            return OrchestratorUtils.getComputeResourcePreference(context, gatewayId, processModel.getComputeResourceId());
        }
        catch (AppCatalogException e) {
            logger.error("Error occurred while initializing app catalog", (Throwable)e);
            throw new RegistryException("Error occurred while initializing app catalog", (Throwable)e);
        }
    }

    public static StoragePreference getStoragePreference(OrchestratorContext context, ProcessModel processModel, String gatewayId) throws RegistryException {
        try {
            GwyResourceProfile gatewayProfile = OrchestratorUtils.getGatewayProfile(context);
            String resourceHostId = processModel.getComputeResourceId();
            return gatewayProfile.getStoragePreference(gatewayId, resourceHostId);
        }
        catch (AppCatalogException e) {
            logger.error("Error occurred while initializing app catalog", (Throwable)e);
            throw new RegistryException("Error occurred while initializing app catalog", (Throwable)e);
        }
    }

    public static String getLoginUserName(OrchestratorContext context, ProcessModel processModel, String gatewayId) throws RegistryException, AiravataException {
        try {
            ComputeResourcePreference computeResourcePreference = OrchestratorUtils.getComputeResourcePreference(context, gatewayId, processModel.getComputeResourceId());
            ComputationalResourceSchedulingModel processResourceSchedule = processModel.getProcessResourceSchedule();
            if (processModel.isUseUserCRPref()) {
                UsrResourceProfile userResourceProfile = OrchestratorUtils.getUserResourceProfile(context);
                UserComputeResourcePreference userComputeResourcePreference = userResourceProfile.getUserComputeResourcePreference(processModel.getUserName(), gatewayId, processModel.getComputeResourceId());
                if (OrchestratorUtils.isValid(userComputeResourcePreference.getLoginUserName())) {
                    return userComputeResourcePreference.getLoginUserName();
                }
                if (OrchestratorUtils.isValid(processResourceSchedule.getOverrideLoginUserName())) {
                    logger.warn("User computer resource preference doesn't have valid user login name, using computer resource scheduling login name " + processResourceSchedule.getOverrideLoginUserName());
                    return processResourceSchedule.getOverrideLoginUserName();
                }
                if (OrchestratorUtils.isValid(computeResourcePreference.getLoginUserName())) {
                    logger.warn("Either User computer resource preference or computer resource scheduling doesn't have valid user login name, using  gateway computer resource preference login name " + computeResourcePreference.getLoginUserName());
                    return computeResourcePreference.getLoginUserName();
                }
                throw new AiravataException("Login name is not found");
            }
            if (OrchestratorUtils.isValid(processResourceSchedule.getOverrideLoginUserName())) {
                return processResourceSchedule.getOverrideLoginUserName();
            }
            if (OrchestratorUtils.isValid(computeResourcePreference.getLoginUserName())) {
                logger.warn("Process compute resource scheduling doesn't have valid user login name, using  gateway computer resource preference login name " + computeResourcePreference.getLoginUserName());
                return computeResourcePreference.getLoginUserName();
            }
            throw new AiravataException("Login name is not found");
        }
        catch (AppCatalogException e) {
            logger.error("Error occurred while initializing app catalog to fetch login username", (Throwable)e);
            throw new RegistryException("Error occurred while initializing app catalog to fetch login username", (Throwable)e);
        }
    }

    public static String getScratchLocation(OrchestratorContext context, ProcessModel processModel, String gatewayId) throws RegistryException, AiravataException {
        try {
            ComputeResourcePreference computeResourcePreference = OrchestratorUtils.getComputeResourcePreference(context, gatewayId, processModel.getComputeResourceId());
            ComputationalResourceSchedulingModel processResourceSchedule = processModel.getProcessResourceSchedule();
            if (processModel.isUseUserCRPref()) {
                UsrResourceProfile userResourceProfile = OrchestratorUtils.getUserResourceProfile(context);
                UserComputeResourcePreference userComputeResourcePreference = userResourceProfile.getUserComputeResourcePreference(processModel.getUserName(), gatewayId, processModel.getComputeResourceId());
                if (OrchestratorUtils.isValid(userComputeResourcePreference.getScratchLocation())) {
                    return userComputeResourcePreference.getScratchLocation();
                }
                if (OrchestratorUtils.isValid(processResourceSchedule.getOverrideScratchLocation())) {
                    logger.warn("User computer resource preference doesn't have valid scratch location, using computer resource scheduling scratch location " + processResourceSchedule.getOverrideScratchLocation());
                    return processResourceSchedule.getOverrideScratchLocation();
                }
                if (OrchestratorUtils.isValid(computeResourcePreference.getScratchLocation())) {
                    logger.warn("Either User computer resource preference or computer resource scheduling doesn't have valid scratch location, using  gateway computer resource preference scratch location" + computeResourcePreference.getScratchLocation());
                    return computeResourcePreference.getScratchLocation();
                }
                throw new AiravataException("Scratch location is not found");
            }
            if (OrchestratorUtils.isValid(processResourceSchedule.getOverrideScratchLocation())) {
                return processResourceSchedule.getOverrideScratchLocation();
            }
            if (OrchestratorUtils.isValid(computeResourcePreference.getScratchLocation())) {
                logger.warn("Process compute resource scheduling doesn't have valid scratch location, using  gateway computer resource preference scratch location" + computeResourcePreference.getScratchLocation());
                return computeResourcePreference.getScratchLocation();
            }
            throw new AiravataException("Scratch location is not found");
        }
        catch (AppCatalogException e) {
            logger.error("Error occurred while initializing app catalog to fetch scratch location", (Throwable)e);
            throw new RegistryException("Error occurred while initializing app catalog to fetch scratch location", (Throwable)e);
        }
    }

    public static JobSubmissionInterface getPreferredJobSubmissionInterface(OrchestratorContext context, ProcessModel processModel, String gatewayId) throws RegistryException {
        try {
            String resourceHostId = processModel.getComputeResourceId();
            ComputeResourcePreference resourcePreference = OrchestratorUtils.getComputeResourcePreference(context, processModel, gatewayId);
            JobSubmissionProtocol preferredJobSubmissionProtocol = resourcePreference.getPreferredJobSubmissionProtocol();
            ComputeResourceDescription resourceDescription = context.getRegistry().getAppCatalog().getComputeResource().getComputeResource(resourceHostId);
            List jobSubmissionInterfaces = resourceDescription.getJobSubmissionInterfaces();
            HashMap<JobSubmissionProtocol, List<JobSubmissionInterface>> orderedInterfaces = new HashMap<JobSubmissionProtocol, List<JobSubmissionInterface>>();
            List<JobSubmissionInterface> interfaces = new ArrayList();
            if (jobSubmissionInterfaces != null && !jobSubmissionInterfaces.isEmpty()) {
                for (JobSubmissionInterface submissionInterface : jobSubmissionInterfaces) {
                    if (preferredJobSubmissionProtocol != null) {
                        if (!preferredJobSubmissionProtocol.toString().equals(submissionInterface.getJobSubmissionProtocol().toString())) continue;
                        if (orderedInterfaces.containsKey(submissionInterface.getJobSubmissionProtocol())) {
                            List interfaceList = (List)orderedInterfaces.get(submissionInterface.getJobSubmissionProtocol());
                            interfaceList.add(submissionInterface);
                            continue;
                        }
                        interfaces.add(submissionInterface);
                        orderedInterfaces.put(submissionInterface.getJobSubmissionProtocol(), interfaces);
                        continue;
                    }
                    Collections.sort(jobSubmissionInterfaces, (jobSubmissionInterface, jobSubmissionInterface2) -> jobSubmissionInterface.getPriorityOrder() - jobSubmissionInterface2.getPriorityOrder());
                }
            } else {
                throw new RegistryException("Compute resource should have at least one job submission interface defined...");
            }
            interfaces = (List)orderedInterfaces.get(preferredJobSubmissionProtocol);
            Collections.sort(interfaces, (jobSubmissionInterface, jobSubmissionInterface2) -> jobSubmissionInterface.getPriorityOrder() - jobSubmissionInterface2.getPriorityOrder());
            return (JobSubmissionInterface)interfaces.get(0);
        }
        catch (AppCatalogException e) {
            throw new RegistryException("Error occurred while retrieving data from app catalog", (Throwable)e);
        }
    }

    public static DataMovementInterface getPrefferredDataMovementInterface(OrchestratorContext context, ProcessModel processModel, String gatewayId) throws RegistryException {
        block4: {
            try {
                String resourceHostId = processModel.getComputeResourceId();
                ComputeResourcePreference resourcePreference = OrchestratorUtils.getComputeResourcePreference(context, processModel, gatewayId);
                DataMovementProtocol preferredDataMovementProtocol = resourcePreference.getPreferredDataMovementProtocol();
                ComputeResourceDescription resourceDescription = context.getRegistry().getAppCatalog().getComputeResource().getComputeResource(resourceHostId);
                List dataMovementInterfaces = resourceDescription.getDataMovementInterfaces();
                if (dataMovementInterfaces != null && !dataMovementInterfaces.isEmpty()) {
                    for (DataMovementInterface dataMovementInterface : dataMovementInterfaces) {
                        if (preferredDataMovementProtocol == null || !preferredDataMovementProtocol.toString().equals(dataMovementInterface.getDataMovementProtocol().toString())) continue;
                        return dataMovementInterface;
                    }
                    break block4;
                }
                throw new RegistryException("Compute resource should have at least one data movement interface defined...");
            }
            catch (AppCatalogException e) {
                throw new RegistryException("Error occurred while retrieving data from app catalog", (Throwable)e);
            }
        }
        return null;
    }

    public static int getDataMovementPort(OrchestratorContext context, ProcessModel processModel, String gatewayId) throws RegistryException {
        try {
            SCPDataMovement scpDataMovement;
            DataMovementProtocol protocol = OrchestratorUtils.getPreferredDataMovementProtocol(context, processModel, gatewayId);
            DataMovementInterface dataMovementInterface = OrchestratorUtils.getPrefferredDataMovementInterface(context, processModel, gatewayId);
            if (protocol == DataMovementProtocol.SCP && (scpDataMovement = OrchestratorUtils.getSCPDataMovement(context, dataMovementInterface.getDataMovementInterfaceId())) != null) {
                return scpDataMovement.getSshPort();
            }
        }
        catch (RegistryException e) {
            logger.error("Error occurred while retrieving security protocol", (Throwable)e);
        }
        return 0;
    }

    public static SecurityProtocol getSecurityProtocol(OrchestratorContext context, ProcessModel processModel, String gatewayId) throws RegistryException {
        try {
            CloudJobSubmission cloudJobSubmission;
            JobSubmissionProtocol submissionProtocol = OrchestratorUtils.getPreferredJobSubmissionProtocol(context, processModel, gatewayId);
            JobSubmissionInterface jobSubmissionInterface = OrchestratorUtils.getPreferredJobSubmissionInterface(context, processModel, gatewayId);
            if (submissionProtocol == JobSubmissionProtocol.SSH) {
                SSHJobSubmission sshJobSubmission = OrchestratorUtils.getSSHJobSubmission(context, jobSubmissionInterface.getJobSubmissionInterfaceId());
                if (sshJobSubmission != null) {
                    return sshJobSubmission.getSecurityProtocol();
                }
            } else if (submissionProtocol == JobSubmissionProtocol.LOCAL) {
                LOCALSubmission localJobSubmission = OrchestratorUtils.getLocalJobSubmission(context, jobSubmissionInterface.getJobSubmissionInterfaceId());
                if (localJobSubmission != null) {
                    return localJobSubmission.getSecurityProtocol();
                }
            } else if (submissionProtocol == JobSubmissionProtocol.SSH_FORK) {
                SSHJobSubmission sshJobSubmission = OrchestratorUtils.getSSHJobSubmission(context, jobSubmissionInterface.getJobSubmissionInterfaceId());
                if (sshJobSubmission != null) {
                    return sshJobSubmission.getSecurityProtocol();
                }
            } else if (submissionProtocol == JobSubmissionProtocol.CLOUD && (cloudJobSubmission = OrchestratorUtils.getCloudJobSubmission(context, jobSubmissionInterface.getJobSubmissionInterfaceId())) != null) {
                return cloudJobSubmission.getSecurityProtocol();
            }
        }
        catch (RegistryException e) {
            logger.error("Error occurred while retrieving security protocol", (Throwable)e);
        }
        return null;
    }

    public static LOCALSubmission getLocalJobSubmission(OrchestratorContext context, String submissionId) throws RegistryException {
        try {
            AppCatalog appCatalog = context.getRegistry().getAppCatalog();
            return appCatalog.getComputeResource().getLocalJobSubmission(submissionId);
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving local job submission with submission id : " + submissionId;
            logger.error(errorMsg, (Throwable)e);
            throw new RegistryException(errorMsg, (Throwable)e);
        }
    }

    public static UnicoreJobSubmission getUnicoreJobSubmission(OrchestratorContext context, String submissionId) throws RegistryException {
        try {
            AppCatalog appCatalog = context.getRegistry().getAppCatalog();
            return appCatalog.getComputeResource().getUNICOREJobSubmission(submissionId);
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving UNICORE job submission with submission id : " + submissionId;
            logger.error(errorMsg, (Throwable)e);
            throw new RegistryException(errorMsg, (Throwable)e);
        }
    }

    public static SSHJobSubmission getSSHJobSubmission(OrchestratorContext context, String submissionId) throws RegistryException {
        try {
            AppCatalog appCatalog = context.getRegistry().getAppCatalog();
            return appCatalog.getComputeResource().getSSHJobSubmission(submissionId);
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving SSH job submission with submission id : " + submissionId;
            logger.error(errorMsg, (Throwable)e);
            throw new RegistryException(errorMsg, (Throwable)e);
        }
    }

    public static CloudJobSubmission getCloudJobSubmission(OrchestratorContext context, String submissionId) throws RegistryException {
        try {
            AppCatalog appCatalog = context.getRegistry().getAppCatalog();
            return appCatalog.getComputeResource().getCloudJobSubmission(submissionId);
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving SSH job submission with submission id : " + submissionId;
            logger.error(errorMsg, (Throwable)e);
            throw new RegistryException(errorMsg, (Throwable)e);
        }
    }

    public static SCPDataMovement getSCPDataMovement(OrchestratorContext context, String dataMoveId) throws RegistryException {
        try {
            AppCatalog appCatalog = context.getRegistry().getAppCatalog();
            return appCatalog.getComputeResource().getSCPDataMovement(dataMoveId);
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving SCP Data movement with submission id : " + dataMoveId;
            logger.error(errorMsg, (Throwable)e);
            throw new RegistryException(errorMsg, (Throwable)e);
        }
    }

    private static boolean isValid(String str) {
        return str != null && !str.trim().isEmpty();
    }
}

