/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.api.GhostResource;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.caching.RegistryCacheEntry;
import org.wso2.carbon.registry.core.caching.RegistryCacheKey;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.RemoteConfiguration;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.MountHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.builtin.SymLinkHandler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.URLMatcher;
import org.wso2.carbon.registry.core.jdbc.realm.RegistryRealm;
import org.wso2.carbon.registry.core.jdbc.utils.ServiceConfigUtil;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.statistics.StatisticsCollector;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.VersionedPath;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;

public final class RegistryUtils {
    private static final Log log = LogFactory.getLog(RegistryUtils.class);
    private static final String ENCODING = System.getProperty("carbon.registry.character.encoding");

    private RegistryUtils() {
    }

    public static VersionedPath getVersionedPath(ResourcePath resourcePath) {
        String versionString = resourcePath.getParameterValue("version");
        long versionNumber = -1L;
        if (versionString != null) {
            versionNumber = Long.parseLong(versionString);
        }
        String plainPath = RegistryUtils.getPureResourcePath(resourcePath.getPath());
        VersionedPath versionedPath = new VersionedPath();
        versionedPath.setPath(plainPath);
        versionedPath.setVersion(versionNumber);
        return versionedPath;
    }

    public static byte[] getByteArray(InputStream inputStream) throws RegistryException {
        if (inputStream == null) {
            String msg = "Could not create memory based content for null input stream.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        ByteArrayOutputStream out = null;
        try {
            int byteCount;
            out = new ByteArrayOutputStream();
            byte[] contentChunk = new byte[1024];
            while ((byteCount = inputStream.read(contentChunk)) != -1) {
                out.write(contentChunk, 0, byteCount);
            }
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            String msg = "Failed to write data to byte array input stream. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                inputStream.close();
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                String msg = "Failed to close streams used for creating memory stream. " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    public static InputStream getMemoryStream(InputStream inputStream) throws RegistryException {
        return new ByteArrayInputStream(RegistryUtils.getByteArray(inputStream));
    }

    public static String getConnectionId(Connection connection) {
        try {
            DatabaseMetaData connectionMetaData = connection.getMetaData();
            if (connectionMetaData != null) {
                return connectionMetaData.getUserName() + "@" + connectionMetaData.getURL();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    public static RegistryCacheKey buildRegistryCacheKey(String connectionId, int tenantId, String resourcePath) {
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        String absoluteLocalRepositoryPath = RegistryUtils.getAbsolutePath(registryContext, "/_system/local");
        if (resourcePath != null && resourcePath.startsWith(absoluteLocalRepositoryPath)) {
            return new RegistryCacheKey(resourcePath, tenantId, registryContext.getNodeIdentifier() + ":" + connectionId.toLowerCase());
        }
        return new RegistryCacheKey(resourcePath, tenantId, connectionId.toLowerCase());
    }

    public static String getPureResourcePath(String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        String preparedPath = resourcePath;
        if (preparedPath.equals("/")) {
            return preparedPath;
        }
        if (!preparedPath.startsWith("/")) {
            preparedPath = "/" + preparedPath;
        }
        if (preparedPath.endsWith("/")) {
            preparedPath = preparedPath.substring(0, preparedPath.length() - 1);
        }
        if (preparedPath.contains("//")) {
            preparedPath = preparedPath.replace("//", "/");
        }
        return preparedPath;
    }

    public static Cache<RegistryCacheKey, GhostResource> getResourceCache(String name) {
        CacheManager manager = RegistryUtils.getCacheManager();
        return manager != null ? manager.getCache(name) : Caching.getCacheManager().getCache(name);
    }

    public static Cache<RegistryCacheKey, RegistryCacheEntry> getResourcePathCache(String name) {
        CacheManager manager = RegistryUtils.getCacheManager();
        return manager != null ? manager.getCache(name) : Caching.getCacheManager().getCache(name);
    }

    private static CacheManager getCacheManager() {
        return Caching.getCacheManagerFactory().getCacheManager("registryCacheManager");
    }

    public static String getParentPath(String resourcePath) {
        String parentPath;
        if (resourcePath == null) {
            return null;
        }
        if (resourcePath.equals("/")) {
            parentPath = null;
        } else {
            String formattedPath = resourcePath;
            if (resourcePath.endsWith("/")) {
                formattedPath = resourcePath.substring(0, resourcePath.length() - "/".length());
            }
            parentPath = formattedPath.lastIndexOf("/") <= 0 ? "/" : formattedPath.substring(0, formattedPath.lastIndexOf("/"));
        }
        return parentPath;
    }

    public static String getResourceName(String resourcePath) {
        String resourceName;
        if (resourcePath.equals("/")) {
            resourceName = "/";
        } else {
            String formattedPath = resourcePath;
            if (resourcePath.endsWith("/")) {
                formattedPath = resourcePath.substring(0, resourcePath.length() - "/".length());
            }
            resourceName = formattedPath.lastIndexOf("/") == 0 ? formattedPath.substring(1, formattedPath.length()) : formattedPath.substring(formattedPath.lastIndexOf("/") + 1, formattedPath.length());
        }
        return resourceName;
    }

    public static void redirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            String msg = "Failed to redirect to the URL " + url + ". \nCaused by " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
        }
    }

    public static String prepareGeneralPath(String rawPath) {
        String path = rawPath;
        if (!rawPath.startsWith("/")) {
            path = "/" + rawPath;
        }
        return path;
    }

    public static boolean hasAdminAuthorizations(String userName, UserRealm userRealm) throws RegistryException {
        try {
            RealmConfiguration realmConfig;
            UserStoreManager userStoreReader = userRealm.getUserStoreManager();
            try {
                realmConfig = userRealm.getRealmConfiguration();
            }
            catch (UserStoreException e) {
                String msg = "Failed to retrieve realm configuration.";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            String systemUser = "wso2.system.user";
            if (systemUser.equals(userName)) {
                return true;
            }
            String adminUser = realmConfig.getAdminUserName();
            if (adminUser.equals(userName)) {
                return true;
            }
            String[] roles = userStoreReader.getRoleListOfUser(userName);
            String adminRoleName = realmConfig.getAdminRoleName();
            if (RegistryUtils.containsString(adminRoleName, roles)) {
                return true;
            }
        }
        catch (UserStoreException e) {
            String msg = "Failed to check authorization level of user " + userName + ". Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        return false;
    }

    public static boolean containsString(String value, String[] array) {
        boolean found = false;
        for (String anArray : array) {
            if (!anArray.equals(value)) continue;
            found = true;
        }
        return found;
    }

    public static boolean containsAsSubString(String value, String[] array) {
        for (String anArray : array) {
            if (!anArray.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static OMElement removeAuthorUpdaterFromDump(OMElement root) {
        Iterator children = root.getChildren();
        String isCollectionString = root.getAttributeValue(new QName("isCollection"));
        boolean isCollection = isCollectionString.equals("true");
        OMElement creatorEle = null;
        OMElement createdTimeEle = null;
        OMElement lastUpdaterEle = null;
        OMElement lastModifiedTimeEle = null;
        OMElement childrenEle = null;
        while (children.hasNext()) {
            Object nextChild = children.next();
            if (!(nextChild instanceof OMElement)) continue;
            OMElement child = (OMElement)nextChild;
            String localName = child.getLocalName();
            if (localName.equals("creator")) {
                creatorEle = child;
                continue;
            }
            if (localName.equals("createdTime")) {
                createdTimeEle = child;
                continue;
            }
            if (localName.equals("lastUpdater")) {
                lastUpdaterEle = child;
                continue;
            }
            if (localName.equals("lastModified")) {
                lastModifiedTimeEle = child;
                continue;
            }
            if (!localName.equals("children")) continue;
            childrenEle = child;
        }
        if (creatorEle != null) {
            creatorEle.detach();
        }
        if (createdTimeEle != null) {
            createdTimeEle.detach();
        }
        if (lastUpdaterEle != null) {
            lastUpdaterEle.detach();
        }
        if (lastModifiedTimeEle != null) {
            lastModifiedTimeEle.detach();
        }
        if (isCollection && childrenEle != null) {
            Iterator grandChildren = childrenEle.getChildren();
            while (grandChildren.hasNext()) {
                Object nextChild = grandChildren.next();
                if (!(nextChild instanceof OMElement)) continue;
                OMElement childE = (OMElement)nextChild;
                RegistryUtils.removeAuthorUpdaterFromDump(childE);
            }
        }
        return root;
    }

    @Deprecated
    public static void addRootCollectionAuthorization(UserRealm userRealm) throws RegistryException {
        AuthorizationUtils.setRootAuthorizations("/", userRealm);
    }

    public static void setTrustStoreSystemProperties() {
        ServerConfiguration config = ServerConfiguration.getInstance();
        String type = config.getFirstProperty("Security.TrustStore.Type");
        String password = config.getFirstProperty("Security.TrustStore.Password");
        String storeFile = new File(config.getFirstProperty("Security.TrustStore.Location")).getAbsolutePath();
        System.setProperty("javax.net.ssl.trustStore", storeFile);
        System.setProperty("javax.net.ssl.trustStoreType", type);
        System.setProperty("javax.net.ssl.trustStorePassword", password);
    }

    public static boolean systemResourceShouldBeAdded(Registry registry, String absolutePath) throws RegistryException {
        RegistryContext registryContext = registry.getRegistryContext();
        if (registryContext == null) {
            registryContext = RegistryContext.getBaseInstance();
        }
        if (registryContext.isSystemResourcePathRegistered(absolutePath)) {
            return false;
        }
        if (registry.resourceExists(absolutePath)) {
            registryContext.registerSystemResourcePath(absolutePath);
            return false;
        }
        return true;
    }

    public static boolean systemResourceShouldBeAdded(ResourceDAO dataAccessObject, String absolutePath) throws RegistryException {
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        if (RegistryContext.getBaseInstance().isSystemResourcePathRegistered(absolutePath)) {
            return false;
        }
        if (dataAccessObject.resourceExists(absolutePath)) {
            registryContext.registerSystemResourcePath(absolutePath);
            return false;
        }
        return true;
    }

    public static void addBaseCollectionStructure(Registry registry, UserRealm userRealm) throws RegistryException {
        RegistryContext registryContext = registry.getRegistryContext();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Checking the existence of '" + RegistryUtils.getAbsolutePath(registryContext, "/_system") + "' collection of the Registry."));
        }
        if (RegistryUtils.systemResourceShouldBeAdded(registry, RegistryUtils.getAbsolutePath(registryContext, "/_system"))) {
            if (registryContext != null && registryContext.isClone()) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating the '" + RegistryUtils.getAbsolutePath(registryContext, "/_system") + "' collection of the Registry."));
            }
            CollectionImpl systemCollection = (CollectionImpl)registry.newCollection();
            String systemDescription = "System collection of the Registry. This collection is used to store the resources required by the carbon server.";
            systemCollection.setDescription(systemDescription);
            registry.put(RegistryUtils.getAbsolutePath(registryContext, "/_system"), systemCollection);
            systemCollection.discard();
            CollectionImpl localRepositoryCollection = (CollectionImpl)registry.newCollection();
            String localRepositoryDescription = "Local data repository of the carbon server. This collection is used to store the resources local to this carbon server instance.";
            localRepositoryCollection.setDescription(localRepositoryDescription);
            registry.put(RegistryUtils.getAbsolutePath(registryContext, "/_system/local"), localRepositoryCollection);
            localRepositoryCollection.discard();
            CollectionImpl configRegistryCollection = (CollectionImpl)registry.newCollection();
            String configRegistryDescription = "Configuration registry of the carbon server. This collection is used to store the resources of this product cluster.";
            configRegistryCollection.setDescription(configRegistryDescription);
            registry.put(RegistryUtils.getAbsolutePath(registryContext, "/_system/config"), configRegistryCollection);
            configRegistryCollection.discard();
            CollectionImpl governanceRegistryCollection = (CollectionImpl)registry.newCollection();
            String governanceRegistryDescription = "Governance registry of the carbon server. This collection is used to store the resources common to the whole platform.";
            governanceRegistryCollection.setDescription(governanceRegistryDescription);
            registry.put(RegistryUtils.getAbsolutePath(registryContext, "/_system/governance"), governanceRegistryCollection);
            governanceRegistryCollection.discard();
        }
        boolean cleanRegistry = false;
        if (System.getProperty("carbon.registry.clean") != null) {
            cleanRegistry = true;
            System.clearProperty("carbon.registry.clean");
        }
        if (cleanRegistry) {
            RegistryUtils.cleanArtifactLCs(registry);
        }
        for (String repositoryPath : new String[]{RegistryUtils.getAbsolutePath(registryContext, "/_system/local/repository"), RegistryUtils.getAbsolutePath(registryContext, "/_system/governance/repository"), RegistryUtils.getAbsolutePath(registryContext, "/_system/config/repository")}) {
            if (cleanRegistry) {
                if (!registry.resourceExists(repositoryPath)) continue;
                try {
                    registry.delete(repositoryPath);
                    log.info((Object)("Cleaned the registry space of carbon at path: " + repositoryPath));
                }
                catch (Exception e) {
                    log.error((Object)("An error occurred while cleaning of registry space of carbon at path: " + repositoryPath), (Throwable)e);
                }
                continue;
            }
            if (!RegistryUtils.systemResourceShouldBeAdded(registry, repositoryPath)) continue;
            registry.put(repositoryPath, registry.newCollection());
        }
    }

    private static void cleanArtifactLCs(Registry registry) throws RegistryException {
        String resourceQuery = "SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R, REG_PROPERTY PP, REG_RESOURCE_PROPERTY RP WHERE";
        String collectionQuery = "SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R, REG_PROPERTY PP, REG_RESOURCE_PROPERTY RP WHERE";
        resourceQuery = StaticConfiguration.isVersioningProperties() ? resourceQuery + "R.REG_VERSION=RP.REG_VERSION AND RP.REG_PROPERTY_ID=PP.REG_ID AND lower(PP.REG_NAME) LIKE ?" : resourceQuery + "R.REG_PATH_ID=RP.REG_PATH_ID AND ((R.REG_NAME = RP.REG_RESOURCE_NAME)) AND RP.REG_PROPERTY_ID=PP.REG_ID AND lower(PP.REG_NAME) LIKE ?";
        collectionQuery = StaticConfiguration.isVersioningProperties() ? collectionQuery + "R.REG_VERSION=RP.REG_VERSION AND RP.REG_PROPERTY_ID=PP.REG_ID AND  lower(PP.REG_NAME) LIKE ?  AND R.REG_NAME IS NULL" : collectionQuery + "R.REG_PATH_ID=RP.REG_PATH_ID AND R.REG_NAME IS NULL AND RP.REG_RESOURCE_NAME IS NULL AND RP.REG_PROPERTY_ID=PP.REG_ID AND  lower(PP.REG_NAME) LIKE ?  AND R.REG_NAME IS NULL";
        HashMap<String, String> paramMapResources = new HashMap<String, String>();
        paramMapResources.put("1", "registry.lc.name");
        paramMapResources.put("query", resourceQuery);
        HashMap<String, String> paramMapCollections = new HashMap<String, String>();
        paramMapCollections.put("1", "registry.lc.name");
        paramMapCollections.put("query", collectionQuery);
        String[] resourcePaths = (String[])registry.executeQuery(null, paramMapResources).getContent();
        String[] collectionpaths = (String[])registry.executeQuery(null, paramMapCollections).getContent();
        for (String path : resourcePaths) {
            RegistryUtils.removeArtifactLC(path, registry);
        }
        for (String path : collectionpaths) {
            RegistryUtils.removeArtifactLC(path, registry);
        }
    }

    private static void removeArtifactLC(String path, Registry registry) throws RegistryException {
        try {
            Resource resource = registry.get(path);
            Properties props = resource.getProperties();
            Iterator<Object> iKeys = props.keySet().iterator();
            ArrayList<String> propertiesToRemove = new ArrayList<String>();
            while (iKeys.hasNext()) {
                String propKey = (String)iKeys.next();
                if (!propKey.startsWith("registry.custom_lifecycle.votes.") && !propKey.startsWith("registry.custom_lifecycle.user.") && !propKey.startsWith("registry.custom_lifecycle.checklist.") && !propKey.startsWith("registry.LC.name") && !propKey.startsWith("registry.lifecycle.") && !propKey.startsWith("registry.Aspects")) continue;
                propertiesToRemove.add(propKey);
            }
            for (String propertyName : propertiesToRemove) {
                resource.removeProperty(propertyName);
            }
            registry.put(path, resource);
        }
        catch (RegistryException e) {
            String msg = "Failed to remove LifeCycle from resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)((Object)e));
            throw new RegistryException(msg, (Throwable)((Object)e));
        }
    }

    @Deprecated
    public static void addSystemCollection(Registry registry, UserRealm userRealm) throws RegistryException {
        throw new UnsupportedOperationException("This operation is no longer supported.");
    }

    @Deprecated
    public static void addCarbonRootCollection(Registry userRegistry, UserRealm userRealm) throws RegistryException {
    }

    @Deprecated
    public static void addTenantsCollection(Registry registry, UserRealm userRealm) throws RegistryException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public static void addUserProfileCollection(Registry registry, String profilesPath) throws RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Checking the existence of the '" + profilesPath + "' collection of the Registry."));
        }
        if (RegistryUtils.systemResourceShouldBeAdded(registry, profilesPath)) {
            if (registry.getRegistryContext() != null && registry.getRegistryContext().isClone()) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating the '" + profilesPath + "' collection of the Registry."));
            }
            CollectionImpl systemCollection = (CollectionImpl)registry.newCollection();
            String systemDescription = "Collection which contains user-specific details.";
            systemCollection.setDescription(systemDescription);
            registry.put(profilesPath, systemCollection);
        }
    }

    public static void addServiceStoreCollection(Registry registry, String servicePath) throws RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Checking the existence of the '" + servicePath + "' collection of the Registry."));
        }
        if (RegistryUtils.systemResourceShouldBeAdded(registry, servicePath)) {
            if (registry.getRegistryContext() != null && registry.getRegistryContext().isClone()) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating the '" + servicePath + "' collection of the Registry."));
            }
            CollectionImpl systemCollection = (CollectionImpl)registry.newCollection();
            String systemDescription = "Collection which contains all the Service information";
            systemCollection.setDescription(systemDescription);
            registry.put(servicePath, systemCollection);
        }
    }

    public static void addMountCollection(Registry registry) throws RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Checking the existence of the '/_system/local/repository/components/org.wso2.carbon.registry/mount' collection of the Registry.");
        }
        if (!registry.resourceExists("/_system/local/repository/components/org.wso2.carbon.registry/mount")) {
            if (registry.getRegistryContext() != null && registry.getRegistryContext().isClone()) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Creating the '/_system/local/repository/components/org.wso2.carbon.registry/mount' collection of the Registry.");
            }
            Collection mountCollection = registry.newCollection();
            String description = "Mount collection stores details of mount points of the registry.";
            mountCollection.setDescription(description);
            registry.put("/_system/local/repository/components/org.wso2.carbon.registry/mount", mountCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMountPoints(Registry systemRegistry, int tenantId) throws RegistryException {
        String[] mountPoints;
        String mountPath = "/_system/local/repository/components/org.wso2.carbon.registry/mount";
        if (!systemRegistry.resourceExists(mountPath)) {
            return;
        }
        CollectionImpl mountCollection = (CollectionImpl)systemRegistry.get(mountPath);
        for (String mountPointString : mountPoints = mountCollection.getChildren()) {
            if (!systemRegistry.resourceExists(mountPointString)) {
                log.warn((Object)("Unable to add mount. The mount point " + mountPointString + " was not found."));
                continue;
            }
            Resource mountPoint = systemRegistry.get(mountPointString);
            if (Boolean.toString(true).equals(mountPoint.getProperty("registry.fixedmount"))) continue;
            String path = mountPoint.getProperty("path");
            String target = mountPoint.getProperty("target");
            String targetSubPath = mountPoint.getProperty("subPath");
            String author = mountPoint.getProperty("author");
            try {
                CurrentSession.setCallerTenantId(tenantId);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Creating the mount point. path: " + path + ", " + "target: " + target + ", " + "target sub path " + targetSubPath + "."));
                }
                if (targetSubPath != null) {
                    RegistryUtils.registerHandlerForRemoteLinks(systemRegistry.getRegistryContext(), path, target, targetSubPath, author);
                    continue;
                }
                RegistryUtils.registerHandlerForSymbolicLinks(systemRegistry.getRegistryContext(), path, target, author);
            }
            catch (RegistryException e) {
                log.warn((Object)("Couldn't mount " + target + "."));
                log.debug((Object)"Caused by: ", (Throwable)((Object)e));
            }
            finally {
                CurrentSession.removeCallerTenantId();
            }
        }
    }

    public static URLMatcher getMountingMatcher(String path) {
        MountingMatcher matcher = new MountingMatcher();
        String matchedWith = Pattern.quote(path) + "($|" + "/" + ".*|" + ";" + ".*)";
        matcher.setPattern(matchedWith);
        return matcher;
    }

    public static String[] getMountingMethods() {
        return new String[]{"RESOURCE_EXISTS", "GET", "PUT", "DELETE", "RENAME", "MOVE", "COPY", "GET_AVERAGE_RATING", "GET_RATING", "RATE_RESOURCE", "GET_COMMENTS", "ADD_COMMENT", "EDIT_COMMENT", "REMOVE_COMMENT", "GET_TAGS", "APPLY_TAG", "REMOVE_TAG", "GET_ALL_ASSOCIATIONS", "GET_ASSOCIATIONS", "ADD_ASSOCIATION", "DUMP", "RESTORE", "REMOVE_ASSOCIATION", "IMPORT", "EXECUTE_QUERY", "GET_RESOURCE_PATHS_WITH_TAG", "GET_REGISTRY_CONTEXT", "REMOVE_LINK"};
    }

    public static void addServiceConfigResources(Registry registry) throws RegistryException {
        try {
            boolean inTransaction = Transaction.isStarted();
            if (!inTransaction) {
                registry.beginTransaction();
            }
            ServiceConfigUtil.addConfig(registry);
            ServiceConfigUtil.addConfigSchema(registry);
            if (!inTransaction) {
                registry.commitTransaction();
            }
        }
        catch (Exception e) {
            String msg = "Unable to setup service configuration.";
            log.error((Object)msg, (Throwable)e);
            registry.rollbackTransaction();
            throw new RegistryException(e.getMessage(), e);
        }
    }

    public static String concatenateChroot(String chroot1, String chroot2) {
        String chroot1out = chroot1;
        if (chroot1out == null || chroot1out.equals("/")) {
            return chroot2;
        }
        if (chroot2 == null || chroot2.equals("/")) {
            return chroot1out;
        }
        if (!chroot1out.endsWith("/") && !chroot2.startsWith("/")) {
            chroot1out = chroot1out + "/";
        } else if (chroot1out.endsWith("/") && chroot2.startsWith("/")) {
            chroot1out = chroot1out.substring(0, chroot1out.length() - 1);
        }
        String chroot = chroot1out + chroot2;
        if (chroot.endsWith("/")) {
            chroot = chroot.substring(0, chroot.length() - 1);
        }
        return chroot;
    }

    public static boolean isRegistryReadOnly(RegistryContext registryContext) {
        String repositoryWriteModeProperty = System.getProperty("carbon.repo.write.mode");
        if (repositoryWriteModeProperty != null) {
            return !repositoryWriteModeProperty.equals("true");
        }
        ServerConfiguration serverConfig = CarbonUtils.getServerConfiguration();
        String isRegistryReadOnly = serverConfig.getFirstProperty("Registry.ReadOnly");
        if (isRegistryReadOnly == null) {
            if (registryContext != null) {
                return registryContext.isReadOnly();
            }
            return RegistryContext.getBaseInstance().isReadOnly();
        }
        return isRegistryReadOnly.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public static Registry getSystemRegistry(Registry coreRegistry) throws RegistryException {
        RealmService realmService = coreRegistry.getRegistryContext().getRealmService();
        String systemUser = "wso2.system.user";
        if (systemUser.equals(CurrentSession.getUser())) {
            return CurrentSession.getUserRegistry();
        }
        return new UserRegistry(systemUser, CurrentSession.getTenantId(), coreRegistry, realmService, CurrentSession.getChroot(), true);
    }

    @Deprecated
    public static UserRealm getBootstrapRealm() throws RegistryException {
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        if (registryContext == null) {
            String msg = "Registry context is null. Failed to get the registry context.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        if (registryContext.getRealmService() == null) {
            String msg = "Error in getting the bootstrap realm. The realm service is not available.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        try {
            UserRealm realm = registryContext.getRealmService().getBootstrapRealm();
            return new RegistryRealm(realm);
        }
        catch (Exception e) {
            String msg = "Error in getting the user realm for main tenant.";
            log.error((Object)msg);
            throw new RegistryException(msg, e);
        }
    }

    public static void recordStatistics(Object ... parameters) {
        StatisticsCollector[] statisticsCollectors;
        for (StatisticsCollector collector : statisticsCollectors = RegistryContext.getBaseInstance().getStatisticsCollectors()) {
            collector.collect(parameters);
        }
    }

    public static UserRealm getBootstrapRealm(RealmService realmService) throws RegistryException {
        try {
            UserRealm realm = realmService.getBootstrapRealm();
            return new RegistryRealm(realm);
        }
        catch (Exception e) {
            String msg = "Error in getting the user realm for main tenant.";
            log.error((Object)msg);
            throw new RegistryException(msg, e);
        }
    }

    public static String getUnChrootedPath(String path) {
        String temp;
        if (path == null) {
            return null;
        }
        String localPath = path;
        if (CurrentSession.getLocalPathMap() != null && (temp = CurrentSession.getLocalPathMap().get(path)) != null) {
            localPath = temp;
        }
        if (CurrentSession.getUserRealm() != null) {
            return localPath;
        }
        String chrootPrefix = RegistryUtils.getChrootPrefix();
        if (chrootPrefix == null) {
            return localPath;
        }
        if (!localPath.startsWith("/")) {
            return localPath;
        }
        if (localPath.equals("/")) {
            return chrootPrefix;
        }
        return chrootPrefix + localPath;
    }

    private static String getChrootPrefix() {
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        if (registryContext == null) {
            return null;
        }
        String chrootPrefix = registryContext.getRegistryRoot();
        if (chrootPrefix == null || chrootPrefix.length() == 0 || chrootPrefix.equals("/")) {
            return null;
        }
        return chrootPrefix;
    }

    public static String getRelativePath(RegistryContext context, String absolutePath) {
        if (context == null) {
            return RegistryUtils.getRelativePathToOriginal(absolutePath, RegistryContext.getBaseInstance().getRegistryRoot());
        }
        return RegistryUtils.getRelativePathToOriginal(absolutePath, context.getRegistryRoot());
    }

    public static String getAbsolutePath(RegistryContext context, String relativePath) {
        if (context == null) {
            return RegistryUtils.getAbsolutePathToOriginal(relativePath, RegistryContext.getBaseInstance().getRegistryRoot());
        }
        return RegistryUtils.getAbsolutePathToOriginal(relativePath, context.getRegistryRoot());
    }

    public static String getRelativePathToOriginal(String absolutePath, String originalPath) {
        if (absolutePath == null) {
            return null;
        }
        if (!absolutePath.startsWith("/")) {
            return absolutePath;
        }
        if (originalPath == null || originalPath.length() == 0 || originalPath.equals("/")) {
            return absolutePath;
        }
        if (originalPath.equals(absolutePath)) {
            return "/";
        }
        if (absolutePath.startsWith(originalPath)) {
            return absolutePath.substring(originalPath.length());
        }
        return "/" + absolutePath;
    }

    public static String getAbsolutePathToOriginal(String relativePath, String originalPath) {
        if (relativePath == null) {
            return null;
        }
        if (!relativePath.startsWith("/")) {
            return relativePath;
        }
        if (originalPath == null || originalPath.length() == 0 || originalPath.equals("/")) {
            return relativePath;
        }
        if (relativePath.startsWith("//")) {
            return relativePath.substring(1);
        }
        return originalPath + relativePath;
    }

    public static void registerHandlerForSymbolicLinks(RegistryContext context, String path, String target, String author) throws RegistryException {
        SymLinkHandler handler = new SymLinkHandler();
        handler.setMountPoint(path);
        handler.setTargetPoint(target);
        handler.setAuthor(author);
        HandlerManager hm = context.getHandlerManager();
        hm.addHandler(RegistryUtils.getMountingMethods(), RegistryUtils.getMountingMatcher(path), handler, "tenant");
        Set<SymLinkHandler> symLinkHandlers = SymLinkHandler.getSymLinkHandlers();
        ArrayList<SymLinkHandler> handlersToRemove = new ArrayList<SymLinkHandler>();
        for (SymLinkHandler symLinkHandler : symLinkHandlers) {
            String symLinkTarget = symLinkHandler.getTargetPoint();
            String mountPath = symLinkHandler.getMountPoint();
            if (!path.equals(mountPath) || target.equals(symLinkTarget)) continue;
            handlersToRemove.add(symLinkHandler);
        }
        for (SymLinkHandler handlerToRemove : handlersToRemove) {
            hm.removeHandler(handlerToRemove, "tenant");
        }
        symLinkHandlers.add(handler);
    }

    public static void registerHandlerForRemoteLinks(RegistryContext registryContext, String path, String target, String targetSubPath, String author) throws RegistryException {
        RegistryUtils.registerHandlerForRemoteLinks(registryContext, path, target, targetSubPath, author, false);
    }

    public static void registerHandlerForRemoteLinks(RegistryContext registryContext, String path, String target, String targetSubPath, String author, boolean forAllTenants) throws RegistryException {
        String msg;
        HandlerManager hm = registryContext.getHandlerManager();
        List<RemoteConfiguration> remoteInstances = registryContext.getRemoteInstances();
        for (RemoteConfiguration config : remoteInstances) {
            if (!config.getId().equals(target)) continue;
            MountHandler handler = new MountHandler();
            handler.setUserName(config.getTrustedUser());
            handler.setPassword(config.getResolvedTrustedPwd());
            handler.setDbConfig(config.getDbConfig());
            handler.setRegistryRoot(config.getRegistryRoot());
            handler.setReadOnly(config.getReadOnly() != null && Boolean.toString(true).equals(config.getReadOnly().toLowerCase()));
            handler.setId(target);
            handler.setConURL(config.getUrl());
            handler.setMountPoint(path);
            handler.setSubPath(targetSubPath);
            handler.setAuthor(author);
            if (config.getTrustedUser() == null || config.getTrustedPwd() == null) {
                handler.setRemote(false);
            } else {
                handler.setRemote(true);
                handler.setRegistryType(config.getType());
            }
            if (forAllTenants) {
                hm.addHandler(RegistryUtils.getMountingMethods(), RegistryUtils.getMountingMatcher(path), handler);
            } else {
                hm.addHandler(RegistryUtils.getMountingMethods(), RegistryUtils.getMountingMatcher(path), handler, "tenant");
            }
            return;
        }
        if (remoteInstances.size() == 0) {
            msg = "No remote instances have been found, The following mount point is not registered. path: " + path + ", " + "target: " + target + ", " + (targetSubPath == null ? "" : "target sub path: " + targetSubPath + ", ");
            log.debug((Object)msg);
        } else {
            msg = "Target mount path is not found, The following mount point is not registered. path: " + path + ", " + "target: " + target + ", " + (targetSubPath == null ? "" : "target sub path: " + targetSubPath + ", ");
            log.debug((Object)msg);
        }
    }

    public static void addMountEntry(Registry registry, RegistryContext registryContext, String path, String target, String targetSubPath, String author) throws RegistryException {
        ResourceImpl r = new ResourceImpl();
        String relativePath = RegistryUtils.getRelativePath(registryContext, path);
        r.addProperty("path", relativePath);
        r.addProperty("target", target);
        r.addProperty("author", author);
        r.addProperty("subPath", targetSubPath);
        r.setMediaType("application/vnd.wso2.mount");
        String mountPath = "/_system/local/repository/components/org.wso2.carbon.registry/mount/" + relativePath.replace("/", "-");
        if (!registry.resourceExists(mountPath)) {
            registry.put(mountPath, r);
        }
    }

    public static void addMountEntry(Registry registry, RegistryContext registryContext, String path, String target, boolean remote, String author) throws RegistryException {
        ResourceImpl r = new ResourceImpl();
        String relativePath = remote ? path : RegistryUtils.getRelativePath(registryContext, path);
        r.addProperty("path", relativePath);
        r.addProperty("target", RegistryUtils.getRelativePath(registryContext, target));
        r.addProperty("author", author);
        r.setMediaType("application/vnd.wso2.mount");
        String mountPath = "/_system/local/repository/components/org.wso2.carbon.registry/mount/" + relativePath.replace("/", "-");
        if (!registry.resourceExists(mountPath)) {
            registry.put(mountPath, r);
        }
    }

    public static ResourceImpl getResourceWithMinimumData(String path, ResourceDAO resourceDAO, boolean versioned) throws RegistryException {
        ResourceIDImpl resourceID = resourceDAO.getResourceID(path);
        if (resourceID == null) {
            return null;
        }
        ResourceImpl resourceImpl = resourceID.isCollection() ? new CollectionImpl() : new ResourceImpl();
        if (versioned) {
            resourceImpl.setVersionNumber(resourceDAO.getVersion(resourceID));
        } else {
            resourceImpl.setName(resourceID.getName());
            resourceImpl.setPathID(resourceID.getPathID());
        }
        resourceImpl.setPath(path);
        return resourceImpl;
    }

    public static String getRelativeAssociationPath(String path, String referencePath) {
        int i;
        String[] referencePathParts = referencePath.split("/");
        String[] pathParts = path.split("/");
        for (i = 0; i < referencePathParts.length - 1 && i < pathParts.length - 1 && referencePathParts[i].equals(pathParts[i]); ++i) {
        }
        StringBuilder prefix = new StringBuilder();
        int j = i;
        while (i < referencePathParts.length - 1) {
            prefix.append("../");
            ++i;
        }
        while (j < pathParts.length - 1) {
            prefix.append(pathParts[j]).append("/");
            ++j;
        }
        String relPath = pathParts.length != 0 ? prefix.append(pathParts[j]).toString() : path;
        while (relPath.contains("//")) {
            relPath = relPath.replaceAll("//", "/../");
        }
        return relPath;
    }

    public static String getAbsoluteAssociationPath(String path, String referencePath) {
        int i;
        String[] referencePathParts = referencePath.split("/");
        String[] pathParts = path.split("/");
        for (i = 0; i < referencePathParts.length - 2 && i < pathParts.length && pathParts[i].equals(".."); ++i) {
        }
        int goUps = i;
        StringBuilder absolutePath = new StringBuilder();
        while (i < pathParts.length && pathParts[i].equals("..")) {
            absolutePath.append("/");
            ++i;
        }
        int remainLen = i;
        for (i = 0; i < referencePathParts.length - goUps - 1; ++i) {
            absolutePath.append(referencePathParts[i]).append("/");
        }
        for (i = remainLen; i < pathParts.length - 1; ++i) {
            absolutePath.append(pathParts[i]).append("/");
        }
        return absolutePath.append(pathParts[pathParts.length - 1]).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class loadClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            File[] files;
            File extensionLibDirectory = new File(RegistryUtils.getExtensionLibDirectoryPath());
            if (extensionLibDirectory.exists() && extensionLibDirectory.isDirectory() && (files = extensionLibDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.endsWith(".jar");
                }
            })) != null && files.length > 0) {
                ArrayList<URL> urls = new ArrayList<URL>(files.length);
                for (File file : files) {
                    try {
                        urls.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException ignore) {
                        // empty catch block
                    }
                }
                ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
                try {
                    URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), RegistryUtils.class.getClassLoader());
                    Class<?> clazz = cl.loadClass(name);
                    return clazz;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origTCCL);
                }
            }
            throw e;
        }
    }

    public static boolean isHiddenProperty(String propertyName) {
        return propertyName.startsWith("registry.");
    }

    public static String getExtensionLibDirectoryPath() {
        CarbonContext carbonContext = CarbonContext.getCurrentContext();
        int tempTenantId = carbonContext.getTenantId();
        return (tempTenantId != -1 && tempTenantId != -1234 ? CarbonUtils.getCarbonTenantsDirPath() + File.separator + carbonContext.getTenantId() : CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server") + File.separator + "registryextensions";
    }

    public static String decodeBytes(byte[] byteContent) throws RegistryException {
        String co;
        try {
            co = ENCODING == null ? new String(byteContent) : new String(byteContent, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            String msg = ENCODING + " is unsupported encoding type";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        return co;
    }

    public static byte[] encodeString(String content) throws RegistryException {
        byte[] bytes;
        try {
            bytes = ENCODING == null ? content.getBytes() : content.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            String msg = ENCODING + " is unsupported encoding type";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        return bytes;
    }

    private static class MountingMatcher
    extends URLMatcher {
        private MountingMatcher() {
        }

        @Override
        public boolean handleExecuteQuery(RequestContext requestContext) throws RegistryException {
            return true;
        }

        @Override
        public boolean handleGetResourcePathsWithTag(RequestContext requestContext) throws RegistryException {
            return true;
        }
    }
}

