/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.servlet;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.util.configuration.ConfigUtil;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class ServletConfigUtil
extends ConfigUtil {
    public static ConfigurationNode findConfigurationNode(ServletContext servletContext, String configFileKey, String configName, String topNodeTag) {
        String fileName = servletContext.getInitParameter(configFileKey);
        if (fileName == null || fileName.length() == 0) {
            throw new MyConfigurationException("Error: No configuration file was specified in the servlet configuration.");
        }
        try {
            return ServletConfigUtil.findConfiguration((String)fileName, (String)servletContext.getInitParameter(configName), (String)topNodeTag);
        }
        catch (MyConfigurationException cx) {
            cx.printStackTrace();
            URL url = null;
            try {
                url = servletContext.getResource(fileName);
            }
            catch (MalformedURLException e) {
                throw new MyConfigurationException("Error: Could not parse URL \"" + fileName + "\". Has a valid configuration been specified?", (Throwable)e);
            }
            if (url == null) {
                throw cx;
            }
            XMLConfiguration cfg = Configurations.getConfiguration((URL)url);
            return ServletConfigUtil.findNamedConfig((XMLConfiguration)cfg, (String)servletContext.getInitParameter(configName), (String)topNodeTag);
        }
    }
}

