/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.entities;

import javax.persistence.EntityManagerFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.util.ClassUtils;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.DefaultJpaEntitiesLocator;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;
import org.compass.gps.device.jpa.support.NativeJpaHelper;

public abstract class JpaEntitiesLocatorDetector {
    public static JpaEntitiesLocator detectLocator(EntityManagerFactory entityManagerFactory, CompassSettings settings) {
        String locatorClassName = NativeJpaHelper.detectNativeJpa(entityManagerFactory, settings, new NativeJpaHelper.NativeJpaCallback<String>(){

            @Override
            public String onHibernate() {
                return "org.compass.gps.device.jpa.entities.HibernateJpaEntitiesLocator";
            }

            @Override
            public String onTopLinkEssentials() {
                return "org.compass.gps.device.jpa.entities.TopLinkEssentialsJpaEntitiesLocator";
            }

            @Override
            public String onEclipseLink() {
                return "org.compass.gps.device.jpa.entities.EclipseLinkJpaEntitiesLocator";
            }

            @Override
            public String onOpenJPA() {
                return "org.compass.gps.device.jpa.entities.OpenJPAJpaEntitiesLocator";
            }

            @Override
            public String onUnknown() {
                return DefaultJpaEntitiesLocator.class.getName();
            }
        });
        try {
            Class locatorClass = ClassUtils.forName(locatorClassName, settings.getClassLoader());
            return (JpaEntitiesLocator)locatorClass.newInstance();
        }
        catch (Exception e) {
            throw new JpaGpsDeviceException("Failed to create locator class [" + locatorClassName + "]", e);
        }
    }
}

