/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.compass.gps.device.jdbc.CannotGetJdbcConnectionException;
import org.compass.gps.device.jdbc.datasource.ConnectionProxy;
import org.compass.gps.device.jdbc.datasource.DriverManagerDataSource;

public class SingleConnectionDataSource
extends DriverManagerDataSource {
    private boolean suppressClose;
    private Connection target;
    private Connection connection;

    public SingleConnectionDataSource() {
    }

    public SingleConnectionDataSource(String driverClassName, String url, String username, String password, boolean suppressClose) throws CannotGetJdbcConnectionException {
        super(driverClassName, url, username, password);
        this.suppressClose = suppressClose;
    }

    public SingleConnectionDataSource(String url, String username, String password, boolean suppressClose) throws CannotGetJdbcConnectionException {
        super(url, username, password);
        this.suppressClose = suppressClose;
    }

    public SingleConnectionDataSource(String url, boolean suppressClose) throws CannotGetJdbcConnectionException {
        super(url);
        this.suppressClose = suppressClose;
    }

    public SingleConnectionDataSource(Connection target, boolean suppressClose) {
        if (target == null) {
            throw new IllegalArgumentException("Connection is null in SingleConnectionDataSource");
        }
        this.suppressClose = suppressClose;
        this.init(target);
    }

    public void setSuppressClose(boolean suppressClose) {
        this.suppressClose = suppressClose;
    }

    public boolean isSuppressClose() {
        return this.suppressClose;
    }

    public boolean shouldClose(Connection con) {
        return con != this.connection && con != this.target;
    }

    protected void init() throws SQLException {
        this.init(this.getConnectionFromDriverManager());
    }

    protected void init(Connection target) {
        this.target = target;
        this.connection = this.suppressClose ? this.getCloseSuppressingConnectionProxy(target) : target;
    }

    public void destroy() throws SQLException {
        if (this.target != null) {
            this.target.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        SingleConnectionDataSource singleConnectionDataSource = this;
        synchronized (singleConnectionDataSource) {
            if (this.connection == null) {
                this.init();
            }
        }
        if (this.connection.isClosed()) {
            throw new SQLException("Connection was closed in SingleConnectionDataSource. Check that user code checks shouldClose() before closing connections, or set suppressClose to true");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Returning single connection [" + this.connection + "]"));
        }
        return this.connection;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.getUsername() != null && this.getUsername().equals(username) && this.getPassword() != null && this.getPassword().equals(password)) {
            return this.getConnection();
        }
        throw new SQLException("SingleConnectionDataSource does not support custom username and password");
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(target));
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private static final String GET_TARGET_CONNECTION_METHOD_NAME = "getTargetConnection";
        private static final String CONNECTION_CLOSE_METHOD_NAME = "close";
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals(GET_TARGET_CONNECTION_METHOD_NAME)) {
                return this.target;
            }
            if (method.getName().equals(CONNECTION_CLOSE_METHOD_NAME)) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

