/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.spell.Dictionary;

public class HighFrequencyDictionary
implements Dictionary {
    private IndexReader reader;
    private String field;
    private float thresh;

    public HighFrequencyDictionary(IndexReader reader, String field, float thresh) {
        this.reader = reader;
        this.field = field.intern();
        this.thresh = thresh;
    }

    public final Iterator getWordsIterator() {
        return new HighFrequencyIterator();
    }

    final class HighFrequencyIterator
    implements Iterator {
        private TermEnum termEnum;
        private Term actualTerm;
        private boolean hasNextCalled;
        private int minNumDocs;

        HighFrequencyIterator() {
            try {
                this.termEnum = HighFrequencyDictionary.this.reader.terms(new Term(HighFrequencyDictionary.this.field, ""));
                this.minNumDocs = (int)(HighFrequencyDictionary.this.thresh * (float)HighFrequencyDictionary.this.reader.numDocs());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean isFrequent(Term term) {
            try {
                return HighFrequencyDictionary.this.reader.docFreq(term) >= this.minNumDocs;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Object next() {
            if (!this.hasNextCalled) {
                this.hasNext();
            }
            this.hasNextCalled = false;
            try {
                this.termEnum.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.actualTerm != null ? this.actualTerm.text() : null;
        }

        public boolean hasNext() {
            if (this.hasNextCalled) {
                return this.actualTerm != null;
            }
            this.hasNextCalled = true;
            while (true) {
                this.actualTerm = this.termEnum.term();
                if (this.actualTerm == null) {
                    return false;
                }
                String currentField = this.actualTerm.field();
                if (currentField != HighFrequencyDictionary.this.field) {
                    this.actualTerm = null;
                    return false;
                }
                if (this.isFrequent(this.actualTerm)) {
                    return true;
                }
                try {
                    this.termEnum.next();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

