/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXOMBuilder
extends DefaultHandler
implements LexicalHandler {
    private OMDocument document;
    OMElement root = null;
    OMNode lastNode = null;
    OMElement nextElem = null;
    private final OMFactory factory;
    List prefixMappings = new ArrayList();
    int textNodeType = 4;

    public SAXOMBuilder(OMFactory factory) {
        this.factory = factory;
    }

    public SAXOMBuilder() {
        this(OMAbstractFactory.getOMFactory());
    }

    private OMContainer getContainer() {
        if (this.lastNode != null) {
            return this.lastNode.isComplete() ? this.lastNode.getParent() : (OMContainer)((Object)this.lastNode);
        }
        if (this.document != null) {
            return this.document;
        }
        throw new OMException("Unexpected event. There is no container to add the node to.");
    }

    private void addNode(OMNode node) {
        if (this.lastNode != null) {
            if (this.lastNode.isComplete()) {
                ((OMNodeEx)this.lastNode).setNextOMSibling(node);
                ((OMNodeEx)node).setPreviousOMSibling(this.lastNode);
            } else {
                ((OMContainerEx)((Object)this.lastNode)).setFirstChild(node);
            }
        } else if (this.document != null) {
            ((OMContainerEx)((Object)this.document)).setFirstChild(node);
        }
        if (this.root == null && node.getType() == 1) {
            this.root = (OMElement)node;
        }
        this.lastNode = node;
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.document = this.factory.createOMDocument(null);
    }

    @Override
    public void endDocument() throws SAXException {
        ((OMContainerEx)((Object)this.document)).setComplete(true);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    protected OMElement createNextElement(String localName) throws OMException {
        OMElement element = this.factory.createOMElement(localName, null, this.getContainer(), null);
        this.addNode(element);
        return element;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.nextElem == null) {
            this.nextElem = this.createNextElement(null);
        }
        if (prefix.isEmpty()) {
            this.nextElem.declareDefaultNamespace(uri);
        } else {
            this.nextElem.declareNamespace(uri, prefix);
        }
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName == null || localName.trim().equals("")) {
            localName = qName.substring(qName.indexOf(58) + 1);
        }
        if (this.nextElem == null) {
            this.nextElem = this.createNextElement(localName);
        } else {
            this.nextElem.setLocalName(localName);
        }
        this.nextElem.setNamespace(this.nextElem.findNamespace(namespaceURI, null));
        int j = atts.getLength();
        for (int i = 0; i < j; ++i) {
            OMNamespace ns;
            if (atts.getQName(i).startsWith("xmlns")) continue;
            String attrNamespaceURI = atts.getURI(i);
            if (attrNamespaceURI.length() > 0) {
                ns = this.nextElem.findNamespace(atts.getURI(i), null);
                if (ns == null) {
                    if (!attrNamespaceURI.equals("http://www.w3.org/XML/1998/namespace")) throw new SAXException("Unbound namespace " + attrNamespaceURI);
                    ns = this.factory.createOMNamespace("http://www.w3.org/XML/1998/namespace", "xml");
                }
            } else {
                ns = null;
            }
            OMAttribute attr = this.nextElem.addAttribute(atts.getLocalName(i), atts.getValue(i), ns);
            attr.setAttributeType(atts.getType(i));
        }
        this.lastNode = this.nextElem;
        this.nextElem = null;
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        if (this.lastNode.isComplete()) {
            OMContainer parent = this.lastNode.getParent();
            ((OMNodeEx)((Object)parent)).setComplete(true);
            this.lastNode = (OMNode)((Object)parent);
        } else {
            OMElement e = (OMElement)this.lastNode;
            ((OMNodeEx)((Object)e)).setComplete(true);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        this.textNodeType = 12;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.textNodeType = 4;
    }

    public void characterData(char[] ch, int start, int length, int nodeType) throws SAXException {
        this.addNode(this.factory.createOMText(this.getContainer(), new String(ch, start, length), nodeType));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characterData(ch, start, length, this.textNodeType);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characterData(ch, start, length, 6);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.addNode(this.factory.createOMProcessingInstruction(this.getContainer(), target, data));
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lastNode == null) {
            return;
        }
        this.addNode(this.factory.createOMComment(this.getContainer(), new String(ch, start, length)));
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    public OMDocument getDocument() {
        if (this.document != null && this.document.isComplete()) {
            return this.document;
        }
        throw new OMException("Tree not complete");
    }

    public OMElement getRootElement() {
        if (this.root != null && this.root.isComplete()) {
            return this.root;
        }
        throw new OMException("Tree not complete");
    }
}

