/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.VersionUtil;
import org.globus.gsi.util.CertificateIOUtil;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.CertificateUtil;
import org.globus.gsi.util.ProxyCertificateUtil;

public class CertUtil {
    public static void init() {
        CertificateUtil.init();
        CertificateLoadUtil.init();
    }

    public static void installSecureRandomProvider() {
        CertificateUtil.installSecureRandomProvider();
    }

    public static void setProvider(String providerName) {
        CertificateUtil.setProvider(providerName);
        CertificateLoadUtil.setProvider(providerName);
    }

    public static X509Certificate loadCertificate(InputStream in) throws GeneralSecurityException {
        return CertificateLoadUtil.loadCertificate(in);
    }

    public static X509Certificate loadCertificate(String file) throws IOException, GeneralSecurityException {
        return CertificateLoadUtil.loadCertificate(file);
    }

    public static X509Certificate[] loadCertificates(String file) throws IOException, GeneralSecurityException {
        return CertificateLoadUtil.loadCertificates(file);
    }

    public static X509Certificate readCertificate(BufferedReader reader) throws IOException, GeneralSecurityException {
        return CertificateLoadUtil.readCertificate(reader);
    }

    public static void writeCertificate(OutputStream out, X509Certificate cert) throws IOException, CertificateEncodingException {
        CertificateIOUtil.writeCertificate(out, cert);
    }

    public static String toGlobusID(String dn) {
        return CertificateUtil.toGlobusID(dn);
    }

    public static String toGlobusID(String dn, boolean noreverse) {
        return CertificateUtil.toGlobusID(dn, noreverse);
    }

    public static String toGlobusID(Principal name) {
        return CertificateUtil.toGlobusID(name);
    }

    public static boolean isProxy(int certType) {
        return ProxyCertificateUtil.isProxy(GSIConstants.CertificateType.get(certType));
    }

    public static boolean isGsi4Proxy(int certType) {
        return ProxyCertificateUtil.isGsi4Proxy(GSIConstants.CertificateType.get(certType));
    }

    public static boolean isGsi3Proxy(int certType) {
        return ProxyCertificateUtil.isGsi3Proxy(GSIConstants.CertificateType.get(certType));
    }

    public static boolean isGsi2Proxy(int certType) {
        return ProxyCertificateUtil.isGsi2Proxy(GSIConstants.CertificateType.get(certType));
    }

    public static boolean isLimitedProxy(int certType) {
        return ProxyCertificateUtil.isLimitedProxy(GSIConstants.CertificateType.get(certType));
    }

    public static boolean isIndependentProxy(int certType) {
        return ProxyCertificateUtil.isIndependentProxy(GSIConstants.CertificateType.get(certType));
    }

    public static boolean isImpersonationProxy(int certType) {
        return ProxyCertificateUtil.isImpersonationProxy(GSIConstants.CertificateType.get(certType));
    }

    public static String getProxyTypeAsString(int proxyType) {
        return ProxyCertificateUtil.getProxyTypeAsString(GSIConstants.CertificateType.get(proxyType));
    }

    public static boolean isGsi3Enabled() {
        return VersionUtil.isGsi3Enabled();
    }

    public static boolean isGsi2Enabled() {
        return VersionUtil.isGsi2Enabled();
    }

    public static X509CRL loadCrl(String file) throws IOException, GeneralSecurityException {
        return CertificateLoadUtil.loadCrl(file);
    }

    public static X509CRL loadCrl(InputStream in) throws GeneralSecurityException {
        return CertificateLoadUtil.loadCrl(in);
    }
}

