/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.messaging;

import java.util.List;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.DBEventManagerConstants;
import org.apache.airavata.common.utils.DBEventService;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.messaging.core.MessagingFactory;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.Subscriber;
import org.apache.airavata.model.dbevent.DBEventMessage;
import org.apache.airavata.model.dbevent.DBEventMessageContext;
import org.apache.airavata.model.dbevent.DBEventSubscriber;
import org.apache.airavata.model.dbevent.DBEventType;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.sharing.registry.messaging.SharingServiceDBEventHandler;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharingServiceDBEventMessagingFactory {
    private static final Logger log = LoggerFactory.getLogger(SharingServiceDBEventMessagingFactory.class);
    private static Publisher dbEventPublisher;
    private static Subscriber sharingServiceDBEventSubscriber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Publisher getDBEventPublisher() throws AiravataException {
        if (null != dbEventPublisher) return dbEventPublisher;
        Class<SharingServiceDBEventMessagingFactory> clazz = SharingServiceDBEventMessagingFactory.class;
        synchronized (SharingServiceDBEventMessagingFactory.class) {
            if (null != dbEventPublisher) return dbEventPublisher;
            log.info("Creating DB Event publisher.....");
            dbEventPublisher = MessagingFactory.getDBEventPublisher();
            log.info("DB Event publisher created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbEventPublisher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Subscriber getDBEventSubscriber() throws AiravataException, SharingRegistryException {
        if (null != sharingServiceDBEventSubscriber) return sharingServiceDBEventSubscriber;
        Class<SharingServiceDBEventMessagingFactory> clazz = SharingServiceDBEventMessagingFactory.class;
        synchronized (SharingServiceDBEventMessagingFactory.class) {
            if (null != sharingServiceDBEventSubscriber) return sharingServiceDBEventSubscriber;
            log.info("Creating DB Event publisher.....");
            sharingServiceDBEventSubscriber = MessagingFactory.getDBEventSubscriber((MessageHandler)new SharingServiceDBEventHandler(), (String)DBEventService.SHARING.toString());
            log.info("DB Event publisher created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharingServiceDBEventSubscriber;
        }
    }

    public static boolean registerSharingServiceWithPublishers(List<String> publishers) throws AiravataException {
        for (String publisher : publishers) {
            log.info("Sending service discovery message. Publisher : " + publisher + ", Subscriber : " + DBEventService.SHARING.toString());
            DBEventSubscriber dbEventSubscriber = new DBEventSubscriber(DBEventService.SHARING.toString());
            DBEventMessageContext dbEventMessageContext = new DBEventMessageContext();
            dbEventMessageContext.setSubscriber(dbEventSubscriber);
            DBEventMessage dbEventMessage = new DBEventMessage(DBEventType.SUBSCRIBER, dbEventMessageContext, publisher);
            MessageContext messageContext = new MessageContext((TBase)dbEventMessage, MessageType.DB_EVENT, "", "");
            SharingServiceDBEventMessagingFactory.getDBEventPublisher().publish(messageContext, DBEventManagerConstants.getRoutingKey((String)DBEventService.DB_EVENT.toString()));
        }
        return true;
    }
}

