/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UntypedSequenceConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeCheckerEnvironment;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public final class TypeChecker {
    private TypeChecker() {
    }

    public static Expression staticTypeCheck(Expression supplied, SequenceType req, boolean backwardsCompatible, RoleLocator role, TypeCheckerEnvironment visitor) throws XPathException {
        Expression cexp;
        XPathException err;
        int relation;
        boolean itemTypeOK;
        boolean cardOK;
        if (supplied.implementsStaticTypeCheck()) {
            return supplied.staticTypeCheck(req, backwardsCompatible, role, visitor);
        }
        Expression exp = supplied;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType reqItemType = req.getPrimaryType();
        int reqCard = req.getCardinality();
        boolean allowsMany = Cardinality.allowsMany(reqCard);
        ItemType suppliedItemType = null;
        int suppliedCard = -1;
        boolean bl = cardOK = reqCard == 57344;
        if (!cardOK) {
            suppliedCard = exp.getCardinality();
            cardOK = Cardinality.subsumes(reqCard, suppliedCard);
        }
        if (!(itemTypeOK = reqItemType instanceof AnyItemType)) {
            suppliedItemType = exp.getItemType();
            if (suppliedItemType instanceof ErrorType) {
                itemTypeOK = true;
            } else {
                if (reqItemType == null || suppliedItemType == null) {
                    throw new NullPointerException();
                }
                relation = th.relationship(reqItemType, suppliedItemType);
                boolean bl2 = itemTypeOK = relation == 0 || relation == 1;
            }
        }
        if (backwardsCompatible && !allowsMany) {
            if (Cardinality.allowsMany(suppliedCard)) {
                Expression cexp2 = FirstItemExpression.makeFirstItemExpression(exp);
                cexp2.adoptChildExpression(exp);
                exp = cexp2;
                suppliedCard = 24576;
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
            if (!itemTypeOK) {
                if (reqItemType.equals(BuiltInAtomicType.STRING)) {
                    StringFn fn = (StringFn)SystemFunctionCall.makeSystemFunction("string", new Expression[]{exp});
                    try {
                        exp = visitor.typeCheck(visitor.simplify(fn), new ContextItemStaticInfo(AnyItemType.getInstance(), true));
                    }
                    catch (XPathException err2) {
                        err2.maybeSetLocation(exp);
                        err2.setIsStaticError(true);
                        throw err2;
                    }
                    suppliedItemType = BuiltInAtomicType.STRING;
                    suppliedCard = 16384;
                    cardOK = Cardinality.subsumes(reqCard, suppliedCard);
                    itemTypeOK = true;
                }
                if (reqItemType.equals(BuiltInAtomicType.NUMERIC) || reqItemType.equals(BuiltInAtomicType.DOUBLE)) {
                    NumberFn fn = (NumberFn)SystemFunctionCall.makeSystemFunction("number", new Expression[]{exp});
                    try {
                        exp = visitor.typeCheck(visitor.simplify(fn), new ContextItemStaticInfo(AnyItemType.getInstance(), true));
                    }
                    catch (XPathException err3) {
                        err3.maybeSetLocation(exp);
                        err3.setIsStaticError(true);
                        throw err3;
                    }
                    suppliedItemType = BuiltInAtomicType.DOUBLE;
                    suppliedCard = 16384;
                    cardOK = Cardinality.subsumes(reqCard, suppliedCard);
                    itemTypeOK = true;
                }
            }
        }
        if (!itemTypeOK) {
            if (reqItemType.isPlainType()) {
                if (!suppliedItemType.isPlainType() && suppliedCard != 8192) {
                    if (!suppliedItemType.isAtomizable()) {
                        XPathException err4 = new XPathException("An atomic value is required for the " + role.getMessage() + ", but the supplied value cannot be atomized", supplied);
                        err4.setErrorCode("FOTY0013");
                        err4.setIsTypeError(true);
                        err4.setLocator(exp);
                        throw err4;
                    }
                    exp = Atomizer.makeAtomizer(exp);
                    Expression cexp3 = visitor.simplify(exp);
                    ExpressionTool.copyLocationInfo(exp, cexp3);
                    exp = cexp3;
                    suppliedItemType = exp.getItemType();
                    suppliedCard = exp.getCardinality();
                    cardOK = Cardinality.subsumes(reqCard, suppliedCard);
                }
                if (suppliedItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                    if (((SimpleType)((Object)reqItemType)).isNamespaceSensitive()) {
                        XPathException err5 = new XPathException("An untyped atomic value cannot be converted to a QName or NOTATION as required for the " + role.getMessage(), supplied);
                        err5.setErrorCode("XPTY0117");
                        err5.setIsTypeError(true);
                        err5.setLocator(exp);
                        throw err5;
                    }
                    UntypedSequenceConverter cexp4 = UntypedSequenceConverter.makeUntypedSequenceConverter(visitor.getConfiguration(), exp, (PlainType)reqItemType);
                    ExpressionTool.copyLocationInfo(exp, cexp4);
                    try {
                        if (exp instanceof Literal) {
                            exp = Literal.makeLiteral(new SequenceExtent(((Expression)cexp4).iterate(visitor.makeDynamicContext())), exp.getContainer());
                            ExpressionTool.copyLocationInfo(cexp4, exp);
                        } else {
                            exp = cexp4;
                        }
                    }
                    catch (XPathException err6) {
                        err6.maybeSetLocation(exp);
                        err6.setErrorCode(role.getErrorCode());
                        err6.setIsStaticError(true);
                        throw err6;
                    }
                    itemTypeOK = true;
                    suppliedItemType = reqItemType;
                }
                if (suppliedItemType.equals(BuiltInAtomicType.ANY_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.ANY_ATOMIC) && (exp.getSpecialProperties() & 0x2000000) == 0) {
                    UntypedSequenceConverter conversion = ((SimpleType)((Object)reqItemType)).isNamespaceSensitive() ? UntypedSequenceConverter.makeUntypedSequenceRejector(visitor.getConfiguration(), exp, (PlainType)reqItemType) : UntypedSequenceConverter.makeUntypedSequenceConverter(visitor.getConfiguration(), exp, (PlainType)reqItemType);
                    ExpressionTool.copyLocationInfo(exp, conversion);
                    try {
                        exp = exp instanceof Literal ? Literal.makeLiteral(new SequenceExtent(((Expression)conversion).iterate(visitor.makeDynamicContext())), exp.getContainer()) : conversion;
                        suppliedItemType = exp.getItemType();
                    }
                    catch (XPathException err7) {
                        err7.maybeSetLocation(exp);
                        err7.setIsStaticError(true);
                        throw err7;
                    }
                }
                if (reqItemType instanceof AtomicType) {
                    Expression cexp5;
                    int rt = ((AtomicType)reqItemType).getFingerprint();
                    if (rt == 517 && th.relationship(suppliedItemType, BuiltInAtomicType.NUMERIC) != 4) {
                        cexp5 = TypeChecker.makePromoterToDouble(exp, visitor);
                        ExpressionTool.copyLocationInfo(exp, cexp5);
                        exp = cexp5;
                        try {
                            exp = visitor.typeCheck(visitor.simplify(exp), new ContextItemStaticInfo(AnyItemType.getInstance(), true));
                        }
                        catch (XPathException err8) {
                            err8.maybeSetLocation(exp);
                            err8.setIsStaticError(true);
                            throw err8;
                        }
                        suppliedItemType = BuiltInAtomicType.DOUBLE;
                        suppliedCard = -1;
                    } else if (rt == 516 && th.relationship(suppliedItemType, BuiltInAtomicType.NUMERIC) != 4 && !th.isSubType(suppliedItemType, BuiltInAtomicType.DOUBLE)) {
                        cexp5 = TypeChecker.makePromoterToFloat(exp, visitor);
                        ExpressionTool.copyLocationInfo(exp, cexp5);
                        exp = cexp5;
                        try {
                            exp = visitor.typeCheck(visitor.simplify(exp), new ContextItemStaticInfo(AnyItemType.getInstance(), true));
                        }
                        catch (XPathException err9) {
                            err9.maybeSetLocation(exp);
                            err9.setIsStaticError(true);
                            throw err9;
                        }
                        suppliedItemType = BuiltInAtomicType.FLOAT;
                        suppliedCard = -1;
                    }
                    if (rt == 513 && th.isSubType(suppliedItemType, BuiltInAtomicType.ANY_URI)) {
                        suppliedItemType = BuiltInAtomicType.STRING;
                        itemTypeOK = true;
                    }
                }
            } else if (reqItemType instanceof FunctionItemType && !((FunctionItemType)reqItemType).isMapType()) {
                if (!(suppliedItemType instanceof FunctionItemType)) {
                    exp = new ItemChecker(exp, th.getGenericFunctionItemType(), role);
                    suppliedItemType = th.getGenericFunctionItemType();
                }
                exp = TypeChecker.makeFunctionSequenceCoercer(exp, (FunctionItemType)reqItemType, visitor, role);
                itemTypeOK = true;
            } else if (reqItemType instanceof ExternalObjectType && Sequence.class.isAssignableFrom(((ExternalObjectType)reqItemType).getJavaClass()) && reqCard == 16384) {
                itemTypeOK = true;
            }
        }
        if (itemTypeOK && cardOK) {
            return exp;
        }
        if (suppliedCard == -1) {
            suppliedCard = exp.getCardinality();
            if (!cardOK) {
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
        }
        if (cardOK && suppliedCard == 8192) {
            return exp;
        }
        if (suppliedCard == 8192 && (reqCard & 0x2000) == 0) {
            XPathException err10 = new XPathException("An empty sequence is not allowed as the " + role.getMessage(), supplied);
            err10.setErrorCode(role.getErrorCode());
            err10.setIsTypeError(role.isTypeError());
            err10.setLocator(exp);
            throw err10;
        }
        relation = itemTypeOK ? 2 : th.relationship(suppliedItemType, reqItemType);
        boolean pessimistic = false;
        if (pessimistic) {
            if (relation != 0 && relation != 2) {
                XPathException err11 = new XPathException("Required item type of " + role.getMessage() + " is " + reqItemType.toString() + "; supplied value has inferred item type " + suppliedItemType.toString() + ". Pessimistic static typing is enabled, so this is an error", supplied);
                err11.setErrorCode(role.getErrorCode());
                err11.setIsTypeError(role.isTypeError());
                err11.setLocator(supplied);
                throw err11;
            }
            if (!Cardinality.subsumes(reqCard, suppliedCard)) {
                XPathException err12 = new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.toString(reqCard) + "; supplied value has inferred cardinality " + Cardinality.toString(suppliedCard) + ". Pessimistic static typing is enabled, so this is an error", supplied);
                err12.setErrorCode(role.getErrorCode());
                err12.setIsTypeError(role.isTypeError());
                err12.setLocator(supplied);
                throw err12;
            }
        } else if (relation == 4) {
            if (Cardinality.allowsZero(suppliedCard) && Cardinality.allowsZero(reqCard)) {
                if (suppliedCard != 8192) {
                    String msg = "Required item type of " + role.getMessage() + " is " + reqItemType.toString() + "; supplied value has item type " + suppliedItemType.toString() + ". The expression can succeed only if the supplied value is an empty sequence.";
                    visitor.issueWarning(msg, supplied);
                }
            } else {
                XPathException err13 = new XPathException("Required item type of " + role.getMessage() + " is " + reqItemType.toString() + "; supplied value has item type " + suppliedItemType.toString(), supplied);
                err13.setErrorCode(role.getErrorCode());
                err13.setIsTypeError(role.isTypeError());
                err13.setLocator(supplied);
                throw err13;
            }
        }
        if (relation != 0 && relation != 2) {
            if (exp instanceof Literal) {
                err = new XPathException("Required item type of " + role.getMessage() + " is " + reqItemType.toString() + "; supplied value has item type " + suppliedItemType.toString(), supplied);
                err.setErrorCode(role.getErrorCode());
                err.setIsTypeError(role.isTypeError());
                err.setLocator(supplied);
                throw err;
            }
            cexp = new ItemChecker(exp, reqItemType, role);
            ExpressionTool.copyLocationInfo(exp, cexp);
            exp = cexp;
        }
        if (!cardOK) {
            if (exp instanceof Literal) {
                err = new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.toString(reqCard) + "; supplied value has cardinality " + Cardinality.toString(suppliedCard), supplied);
                err.setIsTypeError(role.isTypeError());
                err.setErrorCode(role.getErrorCode());
                err.setLocator(supplied);
                throw err;
            }
            cexp = CardinalityChecker.makeCardinalityChecker(exp, reqCard, role);
            ExpressionTool.copyLocationInfo(exp, cexp);
            exp = cexp;
        }
        return exp;
    }

    private static Expression makeFunctionSequenceCoercer(Expression exp, FunctionItemType reqItemType, final TypeCheckerEnvironment visitor, RoleLocator role) throws XPathException {
        TypeCheckerEnvironment tce = new TypeCheckerEnvironment(){
            final Configuration config;
            {
                this.config = visitor.getConfiguration();
            }

            public Configuration getConfiguration() {
                return this.config;
            }

            public void issueWarning(String message, SourceLocator locator) {
            }

            public XPathContext makeDynamicContext() {
                return new EarlyEvaluationContext(this.config);
            }

            public Expression simplify(Expression exp) throws XPathException {
                return exp;
            }

            public Expression typeCheck(Expression exp, ContextItemStaticInfo contextInfo) throws XPathException {
                return exp;
            }
        };
        exp = reqItemType.makeFunctionSequenceCoercer(exp, role, tce);
        return exp;
    }

    public static Expression strictTypeCheck(Expression supplied, SequenceType req, RoleLocator role, StaticContext env) throws XPathException {
        Expression cexp;
        int relation;
        boolean itemTypeOK;
        boolean cardOK;
        Expression exp = supplied;
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        ItemType reqItemType = req.getPrimaryType();
        int reqCard = req.getCardinality();
        ItemType suppliedItemType = null;
        int suppliedCard = -1;
        boolean bl = cardOK = reqCard == 57344;
        if (!cardOK) {
            suppliedCard = exp.getCardinality();
            cardOK = Cardinality.subsumes(reqCard, suppliedCard);
        }
        if (!(itemTypeOK = req.getPrimaryType() instanceof AnyItemType)) {
            suppliedItemType = exp.getItemType();
            relation = th.relationship(reqItemType, suppliedItemType);
            boolean bl2 = itemTypeOK = relation == 0 || relation == 1;
        }
        if (itemTypeOK && cardOK) {
            return exp;
        }
        if (suppliedCard == -1) {
            suppliedCard = suppliedItemType instanceof ErrorType ? 8192 : exp.getCardinality();
            if (!cardOK) {
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
        }
        if (cardOK && suppliedCard == 8192) {
            return exp;
        }
        if (suppliedItemType == null) {
            suppliedItemType = exp.getItemType();
        }
        if (suppliedCard == 8192 && (reqCard & 0x2000) == 0) {
            XPathException err = new XPathException("An empty sequence is not allowed as the " + role.getMessage(), supplied);
            err.setErrorCode(role.getErrorCode());
            err.setIsTypeError(role.isTypeError());
            err.setLocator(exp);
            throw err;
        }
        relation = th.relationship(suppliedItemType, reqItemType);
        if (relation == 4) {
            if (Cardinality.allowsZero(suppliedCard) && Cardinality.allowsZero(reqCard)) {
                if (suppliedCard != 8192) {
                    String msg = "Required item type of " + role.getMessage() + " is " + reqItemType.toString() + "; supplied value has item type " + suppliedItemType.toString() + ". The expression can succeed only if the supplied value is an empty sequence.";
                    env.issueWarning(msg, supplied);
                }
            } else {
                XPathException err = new XPathException("Required item type of " + role.getMessage() + " is " + reqItemType.toString() + "; supplied value has item type " + suppliedItemType.toString(), supplied);
                err.setErrorCode(role.getErrorCode());
                err.setIsTypeError(role.isTypeError());
                err.setLocator(exp);
                throw err;
            }
        }
        if (relation != 0 && relation != 2) {
            cexp = new ItemChecker(exp, reqItemType, role);
            cexp.adoptChildExpression(exp);
            exp = cexp;
        }
        if (!cardOK) {
            if (exp instanceof Literal) {
                XPathException err = new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.toString(reqCard) + "; supplied value has cardinality " + Cardinality.toString(suppliedCard), supplied);
                err.setIsTypeError(role.isTypeError());
                err.setErrorCode(role.getErrorCode());
                throw err;
            }
            cexp = CardinalityChecker.makeCardinalityChecker(exp, reqCard, role);
            cexp.adoptChildExpression(exp);
            exp = cexp;
        }
        return exp;
    }

    public static XPathException testConformance(Sequence val, SequenceType requiredType, XPathContext context) throws XPathException {
        Item item;
        ItemType reqItemType = requiredType.getPrimaryType();
        Configuration config = context.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        SequenceIterator iter = val.iterate();
        int count = 0;
        while ((item = iter.next()) != null) {
            ++count;
            if (reqItemType.matchesItem(item, false, config)) continue;
            XPathException err = new XPathException("Required type is " + reqItemType + "; supplied value has type " + new SequenceExtent(val.iterate()).getItemType(th));
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            return err;
        }
        int reqCardinality = requiredType.getCardinality();
        if (count == 0 && !Cardinality.allowsZero(reqCardinality)) {
            XPathException err = new XPathException("Required type does not allow empty sequence, but supplied value is empty");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            return err;
        }
        if (count > 1 && !Cardinality.allowsMany(reqCardinality)) {
            XPathException err = new XPathException("Required type requires a singleton sequence; supplied value contains " + count + " items");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            return err;
        }
        if (count > 0 && reqCardinality == 8192) {
            XPathException err = new XPathException("Required type requires an empty sequence, but supplied value is non-empty");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            return err;
        }
        return null;
    }

    public static XPathException ebvError(Expression exp, TypeHierarchy th) {
        if (Cardinality.allowsZero(exp.getCardinality())) {
            return null;
        }
        ItemType t = exp.getItemType();
        if (th.relationship(t, Type.NODE_TYPE) == 4 && th.relationship(t, BuiltInAtomicType.BOOLEAN) == 4 && th.relationship(t, BuiltInAtomicType.STRING) == 4 && th.relationship(t, BuiltInAtomicType.ANY_URI) == 4 && th.relationship(t, BuiltInAtomicType.UNTYPED_ATOMIC) == 4 && th.relationship(t, BuiltInAtomicType.NUMERIC) == 4 && !(t instanceof ExternalObjectType)) {
            XPathException err = new XPathException("Effective boolean value is defined only for sequences containing booleans, strings, numbers, URIs, or nodes");
            err.setErrorCode("FORG0006");
            err.setIsTypeError(true);
            return err;
        }
        return null;
    }

    private static Expression makePromoterToDouble(Expression exp, TypeCheckerEnvironment visitor) {
        AtomicSequenceConverter asc = new AtomicSequenceConverter(exp, BuiltInAtomicType.DOUBLE);
        Converter.PromoterToDouble converter = new Converter.PromoterToDouble();
        converter.setConversionRules(visitor.getConfiguration().getConversionRules());
        asc.setConverter(converter);
        ExpressionTool.copyLocationInfo(exp, asc);
        return asc;
    }

    private static Expression makePromoterToFloat(Expression exp, TypeCheckerEnvironment visitor) {
        AtomicSequenceConverter asc = new AtomicSequenceConverter(exp, BuiltInAtomicType.FLOAT);
        Converter.PromoterToFloat converter = new Converter.PromoterToFloat();
        converter.setConversionRules(visitor.getConfiguration().getConversionRules());
        asc.setConverter(converter);
        ExpressionTool.copyLocationInfo(exp, asc);
        return asc;
    }
}

