/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStoreTable;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStoreUtil;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.inject.Provider;

public class SQLAssetStore
extends SQLStore<Asset>
implements AssetStore {
    public static final String DEFAULT_TABLENAME = "transactions";

    public SQLAssetStore() {
    }

    public SQLAssetStore(ConnectionPool connectionPool, Table table, Provider<Asset> assetProvider, MapConverter<Asset> converter) {
        super(connectionPool, table, assetProvider, converter);
    }

    @Override
    public Asset get(String identifier) {
        return AssetStoreUtil.get(identifier, this);
    }

    @Override
    public void save(String identifier, Asset asset) {
        AssetStoreUtil.save(identifier, asset, this);
    }

    protected AssetStoreTable getAST() {
        return (AssetStoreTable)this.getTable();
    }

    @Override
    public Asset getByToken(Identifier token) {
        if (token == null) {
            return null;
        }
        Connection c = this.getConnection();
        Asset t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(this.getAST().getByTokenStatement());
            stmt.setString(1, token.toString());
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                Asset asset = null;
                return asset;
            }
            ColumnMap map = this.rsToMap(rs);
            rs.close();
            stmt.close();
            t = (Asset)this.create();
            this.populate(map, (Identifiable)t);
        }
        catch (SQLException e) {
            this.destroyConnection(c);
            throw new GeneralException("Error getting object with identifier \"" + token + "\"", (Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
        return t;
    }

    @Override
    public void putByToken(Asset asset) {
        this.save((Identifiable)asset);
    }
}

