/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudsearchdomain.model.DocumentServiceWarning;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UploadDocumentsResult
implements Serializable {
    private String status;
    private Long adds;
    private Long deletes;
    private ListWithAutoConstructFlag<DocumentServiceWarning> warnings;

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public UploadDocumentsResult withStatus(String status) {
        this.status = status;
        return this;
    }

    public Long getAdds() {
        return this.adds;
    }

    public void setAdds(Long adds) {
        this.adds = adds;
    }

    public UploadDocumentsResult withAdds(Long adds) {
        this.adds = adds;
        return this;
    }

    public Long getDeletes() {
        return this.deletes;
    }

    public void setDeletes(Long deletes) {
        this.deletes = deletes;
    }

    public UploadDocumentsResult withDeletes(Long deletes) {
        this.deletes = deletes;
        return this;
    }

    public List<DocumentServiceWarning> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new ListWithAutoConstructFlag();
            this.warnings.setAutoConstruct(true);
        }
        return this.warnings;
    }

    public void setWarnings(Collection<DocumentServiceWarning> warnings) {
        if (warnings == null) {
            this.warnings = null;
            return;
        }
        ListWithAutoConstructFlag warningsCopy = new ListWithAutoConstructFlag(warnings.size());
        warningsCopy.addAll(warnings);
        this.warnings = warningsCopy;
    }

    public UploadDocumentsResult withWarnings(DocumentServiceWarning ... warnings) {
        if (this.getWarnings() == null) {
            this.setWarnings(new ArrayList<DocumentServiceWarning>(warnings.length));
        }
        for (DocumentServiceWarning value : warnings) {
            this.getWarnings().add(value);
        }
        return this;
    }

    public UploadDocumentsResult withWarnings(Collection<DocumentServiceWarning> warnings) {
        if (warnings == null) {
            this.warnings = null;
        } else {
            ListWithAutoConstructFlag warningsCopy = new ListWithAutoConstructFlag(warnings.size());
            warningsCopy.addAll(warnings);
            this.warnings = warningsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getAdds() != null) {
            sb.append("Adds: " + this.getAdds() + ",");
        }
        if (this.getDeletes() != null) {
            sb.append("Deletes: " + this.getDeletes() + ",");
        }
        if (this.getWarnings() != null) {
            sb.append("Warnings: " + this.getWarnings());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAdds() == null ? 0 : this.getAdds().hashCode());
        hashCode = 31 * hashCode + (this.getDeletes() == null ? 0 : this.getDeletes().hashCode());
        hashCode = 31 * hashCode + (this.getWarnings() == null ? 0 : this.getWarnings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadDocumentsResult)) {
            return false;
        }
        UploadDocumentsResult other = (UploadDocumentsResult)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAdds() == null ^ this.getAdds() == null) {
            return false;
        }
        if (other.getAdds() != null && !other.getAdds().equals(this.getAdds())) {
            return false;
        }
        if (other.getDeletes() == null ^ this.getDeletes() == null) {
            return false;
        }
        if (other.getDeletes() != null && !other.getDeletes().equals(this.getDeletes())) {
            return false;
        }
        if (other.getWarnings() == null ^ this.getWarnings() == null) {
            return false;
        }
        return other.getWarnings() == null || other.getWarnings().equals(this.getWarnings());
    }
}

